<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
if (!class_exists('phottyTextTable'))
{
    class phottyTextTable extends WP_Widget
    {
        public function __construct()
        {
            wp_enqueue_style('fontawesome', get_template_directory_uri() . '/css/font-awesome.min.css');

            parent::__construct(
                'phottyTextTable',
                'Text Table (PM)',
                array('description' => '')
            );
        }

        public function update($new_instance, $old_instance)
        {
            $instance = $old_instance;

            $instance['title'] = esc_attr($new_instance['title']);
            $instance['storage'] = $new_instance['storage'];

            return $instance;
        }

        public function form($instance)
        {
            $default_values = array(
                'title' => esc_html__('Contact Info', 'photty'),
                'storage' => array(),
            );

            $instance = wp_parse_args((array)$instance, $default_values);
            ?>
            <p class="photty_widget">
                <label>
                    <?php echo esc_html__('Title', 'photty'); ?>:
                </label>
                <input class="widefat"
                       type="text"
                       id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('title')); ?>"
                       value="<?php echo esc_html($instance['title']); ?>"
                />
                <input class="photty_text_table_data_storage_name" type="hidden" name=""
                       value="<?php echo esc_attr($this->get_field_name('storage')); ?>"/>
                <input class="photty_text_table_name_text" type="hidden" name=""
                       value="<?php echo esc_html__('Name', 'photty'); ?>"/>
                <input class="photty_text_table_value_text" type="hidden" name=""
                       value="<?php echo esc_html__('Value', 'photty'); ?>"/>
            </p>
            <div class="photty_text_table_rows photty_widget">
                <?php
                if (isset($instance['storage']) && is_array($instance['storage'])) {
                    foreach ($instance['storage'] as $key => $item) {
                        if (isset($item['name'])) {
                            ?>
                            <div class="photty_text_table_row">
                            <div class="photty_50_dib">
                                <label>
                                    <?php echo esc_html__('Name', 'photty'); ?>:
                                </label>
                                <input class="widefat"
                                       type="text"
                                       name="<?php echo esc_attr($this->get_field_name('storage')); ?>[][name]"
                                       value="<?php echo $item['name']; ?>"
                                />
                            </div>
                            <?php
                            unset($item['name']);
                        }

                        if (isset($item['value'])) {
                            ?>
                            <div class="photty_50_dib">
                                <label>
                                    <?php echo esc_html__('Value', 'photty'); ?>:
                                </label>
                                <textarea class="widefat"
                                          type="text"
                                          name="<?php echo esc_attr($this->get_field_name('storage')); ?>[][value]"
                                ><?php echo $item['value']; ?></textarea>
                            </div>

                            <div class="photty_text_table_row_remove"><i class="fa fa-trash"></i></div>
                            <div class="photty_text_table_row_move"><i class="fa fa-arrows"></i></div>
                            </div>
                            <?php
                            unset($item['value']);
                        }
                    }
                }
                ?>

            </div>
            <input type="button" class="button photty_text_table_add_row"
                   value="<?php echo esc_html__('Add Row', 'photty'); ?>">
            <?php
        }

        public function widget($args, $instance)
        {
            extract($args);

            echo $before_widget;
            echo $before_title;
            echo apply_filters('widget_title', $instance['title']);
            echo $after_title;

            if (isset($instance['storage']) && is_array($instance['storage'])) {
                foreach ($instance['storage'] as $key => $item) {
                    if (isset($item['name'])) {
                        ?>
                        <div class="photty_tt_row">
                        <div class="photty_tt_name">
                            <?php echo $item['name']; ?>:
                        </div>
                        <?php
                        unset($item['name']);
                    }

                    if (isset($item['value'])) {
                        ?>
                        <div class="photty_tt_value">
                            <?php echo $item['value']; ?>
                        </div>
                        </div>
                        <?php
                        unset($item['value']);
                    }
                }
            }

            echo $after_widget;
        }
    }
}