<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
if (!class_exists('phottyGalleryPosts'))
{
    class phottyGalleryPosts extends WP_Widget
    {
        public function __construct()
        {
            parent::__construct(
                'phottyGalleryPosts',
                'Albums (PM)',
                array('description' => '')
            );
        }

        public function update($new_instance, $old_instance)
        {
            $instance = $old_instance;

            $instance['title'] = esc_attr($new_instance['title']);
            $instance['albums_number'] = absint($new_instance['albums_number']);
            $instance['albums_in_row'] = absint($new_instance['albums_in_row']);

            return $instance;
        }

        public function form($instance)
        {
            $default_values = array(
                'title' => esc_html__('Gallery', 'photty'),
                'albums_number' => '6',
                'albums_in_row' => '3'
            );

            $instance = wp_parse_args((array)$instance, $default_values);

            ?>
            <p class="photty_widget">
                <label>
                    <?php echo esc_html__('Title', 'photty'); ?>:
                </label>
                <input class="widefat"
                       type="text"
                       id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('title')); ?>"
                       value="<?php echo esc_html($instance['title']); ?>"
                />
                <label>
                    <?php echo esc_html__('Number of Albums', 'photty'); ?>:
                </label>
                <select name="<?php echo esc_attr($this->get_field_name('albums_number')); ?>"
                        id="<?php echo esc_attr($this->get_field_id('albums_number')); ?>">
                    <option value="3" <?php selected(absint($instance['albums_number']), 3); ?>>3</option>
                    <option value="4" <?php selected(absint($instance['albums_number']), 4); ?>>4</option>
                    <option value="5" <?php selected(absint($instance['albums_number']), 5); ?>>5</option>
                    <option value="6" <?php selected(absint($instance['albums_number']), 6); ?>>6</option>
                    <option value="7" <?php selected(absint($instance['albums_number']), 7); ?>>7</option>
                    <option value="8" <?php selected(absint($instance['albums_number']), 8); ?>>8</option>
                    <option value="9" <?php selected(absint($instance['albums_number']), 9); ?>>9</option>
                </select>
                <label>
                    <?php echo esc_html__('Albums in Row', 'photty'); ?>:
                </label>
                <select name="<?php echo esc_attr($this->get_field_name('albums_in_row')); ?>"
                        id="<?php echo esc_attr($this->get_field_id('albums_in_row')); ?>">
                    <option value="2" <?php selected(absint($instance['albums_in_row']), 2); ?>>2</option>
                    <option value="3" <?php selected(absint($instance['albums_in_row']), 3); ?>>3</option>
                    <option value="4" <?php selected(absint($instance['albums_in_row']), 4); ?>>4</option>
                </select>
            </p>
            <?php
        }

        public function widget($args, $instance)
        {
            extract($args);

            echo $before_widget;
            echo $before_title;
            echo apply_filters('widget_title', $instance['title']);
            echo $after_title;

            $args = array(
                'post_type' => 'albums',
                'post_status' => 'publish',
                'posts_per_page' => absint($instance['albums_number']),
            );

            query_posts($args);

            if (have_posts()) {

                echo '<div class="photty_albums_listing photty_items_'.absint($instance['albums_in_row']).'">';

                while (have_posts()) {
                    the_post();
                    if (photty_get_featured_image_url()) {
                        echo '
                        <div class="photty_album_item">
                            <a href="' . esc_url(get_permalink(get_the_ID())) . '" class="photty_image_fader">
                                <img src="' . aq_resize(photty_get_featured_image_url(), 364, 364, true, true, true) . '" alt="" />
                            </a>
                        </div>
                    ';
                    }
                }
                wp_reset_query();
                echo '</div>';
            }
            echo $after_widget;
        }
    }
}