<?php
/*
Plugin Name: Pixel-Mafia Photty Custom Post Types
Plugin URI: http://www.pixel-mafia.com
Description: Register Photty Custom Post Types.
Version: 1.3
Author: Pixel-Mafia
Author URI: http://www.pixel-mafia.com
*/

function photty_custom_post_types()
{
	$photty_albums_name = esc_attr(get_theme_mod('albums_pt_name', 'Albums'));
	$photty_albums_slug = esc_attr(get_theme_mod('albums_pt_slug', 'albums'));
    # Albums
    register_post_type('albums', array(
            'label' => $photty_albums_name,
            'public' => true,
            'show_ui' => true,
            'show_in_nav_menus' => true,
            'rewrite' => array(
                'slug' => $photty_albums_slug,
                'with_front' => false
            ),
            'hierarchical' => true,
            'menu_position' => 4,
            'supports' => array(
                'title',
                'thumbnail',
				'editor',
				'comments'
            )
        )
    );
	register_taxonomy('albumscat', 'albums', array('hierarchical' => true, 'label' => 'Category', 'singular_name' => 'Category'));
}

add_action('init', 'photty_custom_post_types');

if (!function_exists('photty_load_widgets')) 
{
	function photty_load_widgets() 
	{
		require_once(__DIR__ . "/widgets/featured-gallery-posts.php");
		require_once(__DIR__ . "/widgets/featured-posts.php");
		require_once(__DIR__ . "/widgets/text-table.php");
	}
}
add_action('plugins_loaded', 'photty_load_widgets');

if (!function_exists('photty_add_widget')) 
{
	function photty_add_widget($name) 
	{
		register_widget($name);
	}
}