<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

extract(
    shortcode_atts(
        array(
			'item_image' => '',
			'item_title' => '',
			'item_description' => '',
			'title_color' => '',
			'descr_color' => '',
			'link_type' => 'none',
			'item_link' => '',
			'button_text' => '',
			'button_color' => '',
            'custom_class' => ''
        ),
        $atts
    )
);


$compile = '';
$html = '';
$attach_meta = photty_get_attachment($item_image);
$photoAlt = $attach_meta['alt'];
$featured_image = esc_url(wp_get_attachment_url($item_image));

if ($link_type !== 'none') {
    $btn_link_temp = vc_build_link($item_link);
    $url = $btn_link_temp['url'];
    $link_title = $btn_link_temp['title'];
    $target = $btn_link_temp['target'];

    if ($url !== '') {
        $url = esc_url($url);
    } else {
        $url = '#';
    }
    if ($link_title !== '') {
        $link_title_part = 'title="' . esc_attr($link_title) . '"';
    } else {
        $link_title_part = '';
    }
    if ($target !== '') {
        $link_title_target = 'target="' . esc_attr($target) . '"';
    } else {
        $link_title_target = '';
    }	
}
$photty_link = '';
$photty_link_button = '';
if ($link_type == 'link_all_item') {
	$photty_link = '<a href="' . $url . '" ' . $link_title_part . ' ' . $link_title_target . ' class="stripe_link"></a>';
}
if ($link_type == 'link_by_button') {
	$photty_link_button = '<a href="' . $url . '" ' . $link_title_part . ' ' . $link_title_target . ' class="stripe_button_link photty_js_color" data-color="'. esc_attr($button_color) .'">'. esc_attr($button_text) .'<span class="button_sep photty_js_bg_color" data-bgcolor="'. esc_attr($button_color) .'"></span></a>';
}
$html .= '
	<div class="photty_stripes_item ' . esc_attr($custom_class) . '">
		<div class="photty_stripes_item_inner photty_js_bg_image" data-src="'. $featured_image .'">			
			<div class="photty_stripe_content">
				<h2 class="stripes_title photty_js_color" data-color="'. esc_attr($title_color) .'">'. esc_attr($item_title) .'</h2>
				<div class="stripes_descr photty_js_color" data-color="'. esc_attr($descr_color) .'">'. esc_attr($item_description) .'</div>
				'. $photty_link_button .'
			</div>
			'. $photty_link .'
		</div>
	</div>';
echo photty_output($html);