<?php
extract(
	shortcode_atts(
		array(
			'images' => '',
			'slider_height' => '800px',
			'overlay_bg' => '',
			'autoplay_speed' => '5000',
			'item_title' => '',
			'title_tag' => 'h1',
			'item_caption' => '',
			'title_color' => '#ffffff',
			'caption_color' => '#ffffff',
            'button_state' => '',
            'button_text' => '',
            'button_link' => '',
			'custom_css' => '',
			'custom_class' => ''
		),
		$atts
	)
);

$set_slider_height = $slider_height;
if ($slider_height == '100%') {
	$set_slider_height = '100vh';
}

#JS
wp_enqueue_script('jquery_photty_simple_slider', get_template_directory_uri() . '/js/simple_slider.js', true, false, true);

$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($custom_css, ' '), $this->settings['base'], $atts);

$compile = '';
$images_ids = empty( $images ) ? array() : explode( ',', trim( $images ) );
$uniqid = mt_rand(0, 9999);
$html = '';
$buttom_html = '';

if ($button_state == true) {
    $btn_link_temp = vc_build_link($button_link);
    $url = $btn_link_temp['url'];
    $link_title = $btn_link_temp['title'];
    $target = $btn_link_temp['target'];

    if ($url !== '') {
        $url = esc_url($url);
    } else {
        $url = '#';
    }
    if ($link_title !== '') {
        $link_for_partner = 'title="' . esc_attr($link_title) . '"';
    } else {
        $link_for_partner = '';
    }
    if ($target !== '') {
        $partner_target = 'target="' . esc_attr($target) . '"';
    } else {
        $partner_target = '';
    }

    $buttom_html .= '
		<div class="photty_simple_slider_button_wrapper">
			<a href="' . $url . '" ' . $link_for_partner . ' ' . $partner_target . ' class="photty_button">' . esc_attr($button_text) . '</a>
		</div>
	';
}

if (is_array($images_ids)) {
	
	$html .='<div class="photty_simple_slider_wrapper presetup" style="height:' . esc_attr($slider_height) . '"
                data-uniqid = "' . esc_attr($uniqid) . '"
                data-height = "' . esc_attr($slider_height) . '"
                data-autoplay = "on"
                data-interval = "' . esc_attr($autoplay_speed) . '">
				<div class="photty_simple_slider photty_slider_'. $uniqid .' ' . esc_attr($custom_class) . esc_attr($css_class) . '">';
	$count = 1;
	foreach ($images_ids as $key => $image) {
		$featured_image = wp_get_attachment_url($image);
		$html .='
				<div class="photty_simple_slide photty_js_bg_image simple_slide_loader photty_simple_slide'. $count .'" 
					data-src="'. esc_url($featured_image) .'"
					data-count="'. esc_attr($count) .'"
					>
				';
		$html .='
				</div>
		';
		$count++;
	}
	$html .='</div>';	
	if ($overlay_bg !== '') {
		$html .='
			<div class="photty_simple_slider_overlay photty_js_bg_color" data-bgcolor="'. esc_attr($overlay_bg) .'"></div>
		';
	}
	if ($item_title !== '' || $item_caption !=='' || $button_state == true) {
		$html .='
			<div class="photty_simple_slider_content">
				<'. esc_attr($title_tag) .' class="photty_simple_slider_title photty_js_color" data-color="'. esc_attr($title_color) .'">'. esc_attr($item_title) .'</'. esc_attr($title_tag) .'>
				<div class="photty_simple_slider_caption photty_js_color" data-color="'. esc_attr($caption_color) .'">'. esc_attr($item_caption) .'</div>
				'. $buttom_html .'
			</div>
		';		
	}
	$html .='
	</div>';
}
echo photty_output($html);
?>