<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

extract(
    shortcode_atts(
        array(
			'promo_title' => '',
			'title_tag' => 'h1',
			'promo_text' => '',
			'text_tag' => 'div',
			'button_state' => '',
			'button_text' => '',
			'button_link' => '',
			'custom_css' => '',
			'custom_class' => ''
        ),
        $atts
    )
);

$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($custom_css, ' '), $this->settings['base'], $atts);

$compile = '';
$html = '';

$html .= '
	<div class="photty_promo_text_wrapper ' . esc_attr($custom_class) . esc_attr($css_class) . '">
		<div class="photty_promo_text_inner">
			<'. esc_attr($title_tag) .'>' . esc_attr($promo_title) . '</'. esc_attr($title_tag) .'>
			<'. esc_attr($text_tag) .'>' . $promo_text . '</'. esc_attr($text_tag) .'>
';
if ($button_state == true) {
    $btn_link_temp = vc_build_link($button_link);
    $url = $btn_link_temp['url'];
    $link_title = $btn_link_temp['title'];
    $target = $btn_link_temp['target'];

    if ($url !== '') {
        $url = esc_url($url);
    } else {
        $url = '#';
    }
    if ($link_title !== '') {
        $link_for_partner = 'title="' . esc_attr($link_title) . '"';
    } else {
        $link_for_partner = '';
    }
    if ($target !== '') {
        $partner_target = 'target="' . esc_attr($target) . '"';
    } else {
        $partner_target = '';
    }

    $html .= '
			<div class="photty_promo_text_button_wrapper">
				<a href="' . $url . '" ' . $link_for_partner . ' ' . $partner_target . ' class="photty_button photty_promo_text_button">' . esc_attr($button_text) . '</a>
			</div>
	';
}
$html .= '
		</div>
	</div>';
echo photty_output($html);