<?php
extract(
	shortcode_atts(
		array(
			'images' => '',
			'img_width' => '500',
			'img_height' => '500',
			'on_screen' => '4',
			'lightbox' => '',
			'overlay_bg' => '',
			'items_padding' => '15px',
			'autoplay' => '',
			'autoplay_speed' => '5000',
			'custom_css' => '',
			'custom_class' => ''
		),
		$atts
	)
);

#CSS
wp_enqueue_style('photty-swipebox', get_template_directory_uri() . '/css/swipebox.css');
wp_enqueue_style('owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css');

#JS
wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/js/owl.carousel.min.js', true, false, true);
wp_enqueue_script('jquery_swipebox', get_template_directory_uri() . '/js/jquery.swipebox.js', true, false, true);

$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($custom_css, ' '), $this->settings['base'], $atts);

$compile = '';
$images_ids = empty( $images ) ? array() : explode( ',', trim( $images ) );
$uniqid = mt_rand(0, 9999);
$html = '';

if (is_array($images_ids)) {
	
	$html .='<div class="photty_owlCarousel owl-carousel owl-theme photty_image_carousel ' . esc_attr($custom_class) . esc_attr($css_class) . '"
		data-onScreen = "' . esc_attr($on_screen) . '"
		data-padding = "' . esc_attr($items_padding) . '"
		data-autoplay = "' . esc_attr($autoplay) . '"
		data-speed = "' . esc_attr($autoplay_speed) . '"
	>';
	foreach ($images_ids as $key => $image) {
		$attach_meta = photty_get_attachment($image);
		$photoTitle = $attach_meta['caption'];
		$photoCaption = $attach_meta['description'];
		$photoAlt = $attach_meta['alt'];
		
		$featured_image = wp_get_attachment_url($image);
		$img_thmb = aq_resize(esc_url($featured_image), $img_width, $img_height, true, true, true);
		$html .='
				<div class="photty_img_carousel_item item" data-pad="'. esc_attr($items_padding) .'">
					<img src="'. esc_url($img_thmb) .'" alt="'. esc_attr($photoAlt) .'"  class="img_carousel_thmb"/>
				';
				if ($overlay_bg !== '') {
					$html .='
						<div class="photty_img_carousel_overlay photty_js_bg_color" data-bgcolor="'. esc_attr($overlay_bg) .'"></div>
					';
				}
				if ($lightbox == true) {
					$html .='
						<a class="swipebox" href="'. esc_url($featured_image) .'" title="'. esc_attr($photoTitle) .'"></a>
					';
				}
		$html .='
				</div>
		';
	}
	$html .='</div>';
}
echo photty_output($html);
?>