<?php
extract(
	shortcode_atts(
		array(
			'images' => '',
			'img_width' => '800',
			'img_height' => '600',
			'items_in_row' => '1',
			'masonry' => 'off',
			'posts_first_load' => '12',
			'items_per_load' => '4',
			'overlay_bg' => '',
			'items_padding' => '',
			'button_title' => esc_html__("Load More", "photty"),
			'custom_css' => '',
			'custom_class' => '',
		),
		$atts
	)
);

# CSS
wp_enqueue_style('photty-swipebox', get_template_directory_uri() . '/css/swipebox.css');

# JS
wp_enqueue_script('jquery_swipebox', get_template_directory_uri() . '/js/jquery.swipebox.js', true, false, true);
wp_enqueue_script('jquery_isotope_main', get_template_directory_uri() . '/js/jquery.isotope.min.js', false, true);
wp_enqueue_script('photty_sorting_gallery', get_template_directory_uri() . '/js/sorting_gallery.js', array('jquery', 'jquery_isotope_main'), false, true);

$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($custom_css, ' '), $this->settings['base'], $atts);

$masonry_class = '';
if ($masonry == 'on') {
	$width = $img_width;
	$height = '';
    $masonry_class = 'is_masonry';
} else {
	$width = $img_width;
	$height = $img_height;
}
$compile = '';
$images_ids = empty( $images ) ? array() : explode( ',', trim( $images ) );
$uniqid = mt_rand(0, 9999);
$html = '';
if (is_array($images_ids)) {
	$html .= '
	<div class="photty_grid_wrapper photty_grid_'. esc_attr($uniqid) .' ' . esc_attr($custom_class) . esc_attr($css_class) . '" data-uniqid="'. esc_attr($uniqid) .'" data-perload="'. esc_attr($items_per_load) .'">
		<div class="photty_grid_inner photty_isotope_trigger '. esc_attr($masonry_class).' grid_columns'. esc_attr($items_in_row).'" data-pad="'. esc_attr($items_padding) .'" data-perload="'. esc_attr($items_per_load) .'" data-overlay="'. esc_attr($overlay_bg) .'">
		';
		$grid_array = array();
		$img_array = array();

		$imgCounter = 0;
		foreach ($images_ids as $key => $image) {
			$photoCaption = '';
			$attach_meta = photty_get_attachment($image);
			$photoTitle = $attach_meta['caption'];
			$photoCaption = $attach_meta['description'];
			$photoAlt = $attach_meta['alt'];
			$PCREpattern = '/\r\n|\r|\n/u';
			$photoCaption = preg_replace($PCREpattern, '', nl2br($photoCaption));
			
			$featured_image = wp_get_attachment_url($image);
			if (strlen($featured_image[0]) > 0) {
				$featured_image_url = aq_resize(esc_url($featured_image), $width, $height, true, true, true);
			} else {
				$featured_image_url = '';
			}
			
			$featured_image = wp_get_attachment_image_src($image, 'original');

			$img_array['attach_id'] = $image;
			$img_array['slide_type'] = 'image';
			$img_array['title'] = $photoTitle;
			$img_array['alt'] = $photoAlt;
			$img_array['thmb'] = $featured_image_url;
			$img_array['url'] = $featured_image[0];
			$img_array['count'] = $imgCounter;
			$img_array['overlay_bg'] = esc_attr($overlay_bg);
			array_push($grid_array, $img_array);
		}//EoForeach	

		$post_per_page = $posts_first_load;
		if ($post_per_page > count($grid_array)) {
			$post_per_page = count($grid_array);
		}

		$i = 0;
		while ($i < $post_per_page) {
			if ($grid_array[$i]['slide_type'] == 'image') {
				$thishref = wp_get_attachment_url($grid_array[$i]['attach_id']);
				$thisvideoclass = '';
			} else if ($grid_array[$i]['slide_type'] == 'video') {
				$thishref = $grid_array[$i]['src'];
				$thisvideoclass = 'video_zoom';
			}
			$photoTitle = '';
			$photoTitle = $grid_array[$i]['title'];
			if (isset($photoTitle) && $photoTitle !== '') {
				$photoTitle = str_replace('"', "'", $photoTitle);
			}
			$photoAlt = $grid_array[$i]['alt'];
			$imgCounter = $grid_array[$i]['count'];
			$featured_image = $grid_array[$i]['url'];
			$img_thmb = $grid_array[$i]['thmb'];
			$html .= '
			<div class="grid-item element anim_el anim_el2 load_anim grid_b2p">
				<div class="grid-item-inner">
					<a class="swipebox" rel="grid_gallery'. esc_attr($uniqid) .'" href="'. esc_url($featured_image) .'" title="'. esc_attr($photoTitle) .'"></a>
					<img src="'. esc_url($img_thmb) .'" alt="'. esc_attr($photoAlt) .'"  class="grid_thmb"/>
					<div class="grid_overlay photty_js_bg_color" data-bgcolor="'. esc_attr($overlay_bg) .'"></div>
					<div class="photty-img-preloader"></div>
				</div>
			</div>';
			unset($grid_array[$i]);
			$i++;
		} //EoWhile First Load	
			$html .= '
		</div>';
	if (isset($grid_array) && count($grid_array) > 0) {
		$html .= '<div class="photty_grid_gallery_array" data-id = "'. esc_attr($uniqid) .'">';
			$i = 0;
			foreach ($grid_array as $image) {
				$html .= '<div class="photty_grid_array_item" 
						data-id = "'. esc_attr($uniqid) .'" 
						data-type = "' . esc_attr($image['slide_type']) . '" 
						data-img = "' . esc_url($image['url']) . '" 
						data-thmb = "' . esc_url($image['thmb']) . '" 
						data-title = "' . esc_attr($image['title']) . '" 
						data-alt = "' . esc_attr($image['alt']) . '" 
						data-overlay = "' . esc_attr($image['overlay_bg']) . '" 
						data-counter = "' . esc_attr($image['count']) . '">
					</div>';
			}
		$html .= '</div>';

		$html .= '<div class="grid_loadmore_wrapper"><a class="grid_load_more photty_button" href="'. esc_js("javascript:void(0)") .'">' . esc_attr($button_title) . '</a></div>';
	}
	$html .= '</div>';
}
echo photty_output($html);
?>