<?php
extract(
    shortcode_atts(
        array(
			'thmb_width' => '800',
			'thmb_height' => '600',
			'items_in_row' => '3',
			'posts_first_load' => '9',
			'items_per_load' => '3',
			'items_padding' => '30px',
			'button_title' => 'Load More',
            'custom_css' => '',
            'custom_class' => '',
        ),
        $atts
    )
);

# CSS
wp_enqueue_style('owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css');

# JS
wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/js/owl.carousel.min.js', array('jquery'), false, true);

$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($custom_css, ' '), $this->settings['base'], $atts);

$html = '
<div class="photty_element_wrap photty_blog_grid ' . esc_attr($custom_class) . esc_attr($css_class) . '" 
	data-perload = "'. esc_attr($items_per_load) .'" 
	data-onstart = "'. esc_attr($posts_first_load) .'" 
	data-setpad = "'. esc_attr($items_padding) .'"
	data-inrow = "'. esc_attr($items_in_row) .'">';

$args = array(
    'post_type' => 'post',
    'post_status' => 'publish',
    'posts_per_page' => absint($posts_first_load),
    'paged' => -1,
);

query_posts($args);

$i = 0;
$pf_args = array(
	'output_template' => 'blog_grid',
	'grid_img_width' => $thmb_width,
	'grid_img_height' => $thmb_height
);

$set_query_args = '{"output_template" : "blog_grid_template", "thmb_width" : '. $thmb_width .', "thmb_height" : '. $thmb_height .', "ajax_callback_function" : "photty_theme_setup", "post_type" : "post", "post_status" : "publish", "posts_first_load" : '. $posts_first_load .', "posts_per_page" : '. $items_per_load .', "offset" : 0}';
$html .= '
</div>
<div class="blog_grid_loadmore_wrapper">
	<a class="blog_grid_load_more photty_button photty_ajax_query_posts" data-args=\''. $set_query_args .'\' data-return-to="photty_blog_grid" href="'. esc_js("javascript:void(0)") .'">' . esc_attr($button_title) . '</a>
</div>
';

echo photty_output($html);