<?php
extract(
    shortcode_atts(
        array(
            'posts_per_page' => 5,
            'custom_css' => '',
            'custom_class' => '',
        ),
        $atts
    )
);

$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($custom_css, ' '), $this->settings['base'], $atts);

phottyHelper::getInstance()->addJSToFooter("blog_shared", "
jQuery('.shared_content_buttons_cont').hide();
");

$html = '
<div class="photty_element_wrap photty_element_blog ' . esc_attr($custom_class) . esc_attr($css_class) . '">';

$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

$args = array(
    'post_type' => 'post',
    'post_status' => 'publish',
    'posts_per_page' => absint($posts_per_page),
    'paged' => $paged,
);

query_posts($args);

if (have_posts()) {
    while (have_posts()) {
        the_post();

        $html .= '
        <div class="'.implode(" ", get_post_class('stand_post')).'" id="post-' . get_the_ID() . '">
            ' . photty_get_post_formats() . '
            <div class="photty_title">
                <a class="notextdecor" href="' . get_permalink() . '"><h3 class="innertitle entry-title">' . get_the_title() . '</h3></a>
            </div>
            <div class="photty_meta">
                <div>' . get_the_date() . '</div>
                <div>' . get_the_author_posts_link() . '</div>';

        $categories = get_the_category();
        $separator = ', ';
        if (!empty($categories)) {
            $html .= '
                <div>';
            foreach ($categories as $category) {
                $html .= '<a href="' . esc_url(get_category_link($category->term_id)) . '" alt="' . esc_attr(sprintf(__('View all posts in %s', 'photty'), $category->name)) . '">' . esc_html($category->name) . '</a>' . $separator;
            }
            $html = trim($html, $separator);
            $html .= '
                </div>';
        }

        $html .= '
            </div>
            <div class="photty_excerpt">
                ' . get_the_excerpt() . '
            </div>
            <div class="read_more_cont">
                <a class="photty_button" href="' . get_permalink() . '">' . esc_html__('Read More', 'photty') . '</a>
            </div>
        </div>
        ';
    }

    $html .= get_the_posts_pagination(array(
        'prev_text' => __('<i class="fa fa-angle-left" aria-hidden="true"></i>', 'photty'),
        'next_text' => __('<i class="fa fa-angle-right" aria-hidden="true"></i>', 'photty'),
    ));

    wp_reset_query();

}

$html .= '
</div>';

echo photty_output($html);
?>