<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

if (!post_password_required()) {
	the_post();
	get_header();
	
	$photty_post_classes = array(
		'container',
		photty_get_post_option('header_padding', 'photty_header_padding_yes')
	);
	?>
		<div id="post-<?php the_ID(); ?>" <?php post_class($photty_post_classes); ?>>
			<div class="row <?php echo(photty_get_prefered_option('sidebar_position', 'photty_right_sidebar')); ?>">
				<div
					class="col-md-<?php echo((is_active_sidebar('sidebar') && (photty_get_prefered_option('sidebar_position', 'photty_right_sidebar') !== 'photty_no_sidebar')) ? '9' : '12'); ?> photty_content">
					<?php if (photty_get_post_option('single_page_title', 'show') == 'show') {?>
					<div class="photty_title">
						<h1 class="entry-title"><?php the_title(); ?></h1>
					</div>
					<?php } ?>
					<div class="photty_meta">
						<div><?php echo get_the_date(); ?></div>
						<div><?php echo esc_attr__('by', 'photty'); echo ' '; the_author_posts_link(); ?></div>
						<div><?php echo esc_attr__('in', 'photty'); echo ' '; the_category(', '); ?></div>
						<div><a href="<?php comments_link(); ?>"><?php comments_number(); ?></a></div>
						<?php the_tags('<div>', ', ', '</div>'); ?>
					</div>
					<?php echo photty_get_post_formats(); ?>
					<div class="photty_tiny">
						<?php the_content(); ?>
					</div>
					<div class="photty_subtiny">
						<?php wp_link_pages(array('before' => '<div class="page-link">' . esc_html__('Pages', 'photty') . ': ', 'after' => '</div>')); ?>
					</div>
	
					<?php photty_prev_next_posts(); ?>
	
					<div class="photty_delim"></div>
	
					<?php
					photty_featured_posts(array(
						'orderby' => photty_get_prefered_option('featured_posts_orderby', 'rand'),
						'numberposts' => photty_get_prefered_option('featured_posts_numberposts', '2'),
						'featured_image' => photty_get_prefered_option('featured_posts_fimage_status', 'show'),
						'excerpt' => photty_get_prefered_option('featured_posts_excerpt_status', 'show'),
						'post_meta' => photty_get_prefered_option('featured_posts_meta_status', 'show')
					));
					?>
	
					<?php comments_template(); ?>
				</div>
				<?php get_sidebar('sidebar'); ?>
			</div>
		</div>
	
	<?php
	
	get_footer();
} else {
    get_header('gallery');
	phottyHelper::getInstance()->addJSToFooter('protected_page', '
		jQuery("html").addClass("photty_transparent_header photty_height_100");
		jQuery("body").css("background-image", "url(' . get_theme_mod('protected_bg_image', get_template_directory_uri() . '/img/null.png') . ')").addClass("photty_password_protected");
	');
    ?>

    <div class="photty_password_container">
        <div class="photty_password_form container">
            <?php the_content(); ?>
        </div>
    </div>

    <?php
    get_footer('empty');
}