<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
if (!post_password_required()) {
	
	the_post();
	get_header();
	
	if (get_post_type() == 'albums') {
		$galCateg = '';
		$new_term_list = get_the_terms(get_the_id(), "albumscat");
		if (is_array($new_term_list)) {
			foreach ($new_term_list as $term) {
				$galCateg .= $term->name . " / ";
			}
		} else {
			$galCateg = 'Uncategorized  ';
		}
		$galCateg = substr($galCateg, 0, -2);
		
		$layout_style = photty_get_post_option('photty_albums_images_layout');
		
		if($layout_style == '3x2') {
			$img_width = 915;
			$img_height = 600;
		}
		
		?>
		<div class="photty_single_album_head photty_js_bg_image" data-src="<?php echo photty_get_featured_image_url(); ?>">
			<div class="photty_single_album_title">
				<h1><?php the_title(); ?></h1>
				<div class="entry-meta"><?php echo photty_output($galCateg); ?></div>
			</div>
			<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_album_down_arrow"></a>
		</div>
		<div class="photty_single_album_images_wrapper layout_<?php echo photty_output($layout_style); ?>">
			<div class="photty_single_album_images_inner">
				<?php 
					if (is_array(photty_get_post_option('photty_albums_images'))) {
						$img_count_style = 0;
						foreach (photty_get_post_option('photty_albums_images') as $key => $image) {
							$img_count_style++;
							if($layout_style == '2x1') {
								if ($img_count_style > 3) {
									$img_count_style = 1;
								}
								if ($img_count_style == 3) {
									$img_width = 1920;
									$img_height = 1032;
								} else {
									$img_width = 960;
									$img_height = 630;
								}
							}
							if($layout_style == '3x2' && $img_count_style > 5) {
								$img_count_style = 1;
							}
							$photoTitle = $image['caption'];
							$photoCaption = $image['description'];
							$photoAlt = $image['alt'];
							$PCREpattern = '/\r\n|\r|\n/u';
							$photoCaption = preg_replace($PCREpattern, '', nl2br($photoCaption));
							?>
							<div class="photty_single_album_image photty_single_album_img_style<?php echo photty_output($img_count_style); ?>">
								<div class="photty_single_album_image_inner">
									<a class="swipebox photty_image_fader" href="<?php echo esc_url($image['full_url']); ?>" title="<?php echo esc_attr($photoTitle); ?>">
										<img src="<?php echo aq_resize(esc_url($image['full_url']), $img_width, $img_height, true, true, true); ?>" alt="<?php echo esc_attr($photoAlt); ?>"/>
									</a>
								</div>
							</div>
							<?php
						}
					}			
				?>
			</div>
		</div>
		<?php
			$photty_post_classes = array(
				'container',
				'photty_container',
				photty_get_post_option('header_padding', 'photty_header_padding_yes')
			);
		?>	
		<div id="post-<?php the_ID(); ?>" <?php post_class($photty_post_classes); ?>>
			<div class="row photty_no_sidebar">
				<div
					class="col-md-12">
					<div class="photty_tiny_albums">
						<?php the_content(); ?>
					</div>
	
					<div class="photty_delim photty_album_delim"></div>
				</div>
			</div>
		</div>
	
		<?php
		photty_featured_albums(array(
			'orderby' => photty_get_prefered_option('featured_posts_orderby', 'rand'),
			'numberposts' => photty_get_prefered_option('featured_posts_numberposts', '3'),
			'featured_image' => photty_get_prefered_option('featured_posts_fimage_status', 'show')
		));

	} else {
		$photty_post_classes = array(
			'container',
			photty_get_post_option('header_padding', 'photty_header_padding_yes')
		);
		$photty_pf_image = photty_get_featured_image_url();
		if (strlen($photty_pf_image) > 0) {
		?>
			<div class="photty_single_album_head photty_js_bg_image photty_single_page_head" data-src="<?php echo photty_get_featured_image_url(); ?>">
			<?php if (photty_get_post_option('single_page_title', 'show') == 'show') { ?>
				<div class="photty_single_album_title">
					<h1><?php the_title(); ?></h1>
				</div>
			<?php } ?>
				<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_album_down_arrow"></a>
			</div>
		<?php
		}
		?>
			<div id="post-<?php the_ID(); ?>" <?php post_class($photty_post_classes); ?>>
				<div class="row <?php echo (photty_get_prefered_option('sidebar_position', 'photty_right_sidebar')); ?>">
					<div class="col-md-<?php echo ((is_active_sidebar('sidebar') && (photty_get_prefered_option('sidebar_position', 'photty_right_sidebar') !== 'photty_no_sidebar')) ? '9' : '12'); ?> photty_content">
						<?php if (photty_get_post_option('single_page_title', 'show') == 'show' && strlen($photty_pf_image) < 1) { ?>
						<div class="photty_title">
							<h1 class="entry-title">
								<?php the_title(); ?>
							</h1>
						</div>
						<?php } ?>
						<div class="photty_tiny">
							<?php the_content(); ?>
						</div>
						<div class="photty_subtiny">
							<?php wp_link_pages(array('before' => '<div class="page-link">' . esc_html__('Pages', 'photty') . ': ', 'after' => '</div>')); ?>
						</div>
						<div class="photty_comments_cont"><?php comments_template(); ?></div>
					</div>
					<?php get_sidebar('sidebar'); ?>
				</div>
			</div>
		
		<?php
	}
	
	get_footer();
} else {
    get_header('gallery');
	phottyHelper::getInstance()->addJSToFooter('protected_page', '
		jQuery("html").addClass("photty_transparent_header photty_height_100");
		jQuery("body").css("background-image", "url(' . get_theme_mod('protected_bg_image', get_template_directory_uri() . '/img/null.png') . ')").addClass("photty_password_protected");
	');
    ?>

    <div class="photty_password_container">
        <div class="photty_password_form container">
            <?php the_content(); ?>
        </div>
    </div>

    <?php
    get_footer('empty');
}