<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
 * Template Name: Split Showcase
*/

if (!post_password_required()) {

	the_post();
	get_header();
	
	?>
    <div class="photty_split_showcase_wrapper">
        <div class="photty_split_showcase wait4load">
            <?php 
            $photty_base_count = 1;
            $photty_right_count = 1;
            $photty_left_count = 1;
            if (is_array(photty_get_post_option('photty_template_images'))) {
                foreach (photty_get_post_option('photty_template_images') as $key => $image) {
                    $photoTitle = $image['caption'];
                    $photoCaption = $image['description'];
                    $photoAlt = $image['alt'];
                    $PCREpattern = '/\r\n|\r|\n/u';
                    $photoCaption = preg_replace($PCREpattern, '', nl2br($photoCaption));

                    if(($photty_base_count % 2) == 0){
                        $photty_slide_class = 'photty_right_slide'.$photty_right_count;
                        $photty_slide_style = 'photty_right_slide';
                        $photty_data_count = $photty_right_count;
                        $photty_right_count++;
                    } else {
                        $photty_slide_class = 'photty_left_slide'.$photty_left_count;
                        $photty_slide_style = 'photty_left_slide';
                        $photty_data_count = $photty_left_count;
                        $photty_left_count++;
                    }
                    $photty_base_count++;
                    ?>
                    <div class="photty_split_slide photty_preload_slide <?php echo esc_attr($photty_slide_class) . ' ' . esc_attr($photty_slide_style); ?> photty_js_bg_image" data-count="<?php echo esc_attr($photty_data_count); ?>" data-src="<?php echo esc_url($image['full_url']); ?>">
                        <div class="photty_split_title_wrapper">
                            <h2 class="photty_split_title"><?php echo photty_output($photoTitle); ?></h2>
                            <div class="photty_split_caption"><?php echo photty_output($photoCaption); ?></div>                                
                        </div>
                        <a class="swipebox" href="<?php echo esc_url($image['full_url']); ?>" title="<?php echo esc_attr($photoTitle); ?>"></a>
                        <div class="photty_split_overlay"></div>
                    </div>                        
                    <?php						
                }
            }
            ?>
        </div>
        <a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_split_btn_prev"></a>
        <a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_split_btn_next"></a>
    </div>
	<?php
	
	get_footer('empty');
} else {
    get_header('gallery');
	phottyHelper::getInstance()->addJSToFooter('protected_page', '
		jQuery("html").addClass("photty_transparent_header photty_height_100");
		jQuery("body").css("background-image", "url(' . get_theme_mod('protected_bg_image', get_template_directory_uri() . '/img/null.png') . ')").addClass("photty_password_protected");
	');
    ?>

    <div class="photty_password_container">
        <div class="photty_password_form container">
            <?php the_content(); ?>
        </div>
    </div>

    <?php
    get_footer('empty');
}