<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
 * Template Name: Ribbon Slider
*/
if (!post_password_required()) {

	the_post();
	get_header();
	$autoplay = 'no';
	$interval = '';
	if (photty_get_post_option('photty_slider_autoplay') == 'yes') {
		$autoplay = 'yes';
		if (photty_get_post_option('photty_slider_interval') !== '' && photty_get_post_option('photty_slider_interval') > 0) {
			$interval = photty_get_post_option('photty_slider_interval');
		}
	}
    $uniqid = mt_rand(0, 9999);
	?>
			<div class="photty_ribbon_slider_wrapper"
                data-uniqid="<?php echo esc_attr($uniqid); ?>" 
                data-autoplay = "<?php echo esc_attr($autoplay); ?>" 
                data-interval = "<?php echo esc_attr($interval); ?>">
				<div class="photty_ribbon_slider wait4load">
					<?php
					$counter = 0;
					if (is_array(photty_get_post_option('photty_template_images'))) {
						foreach (photty_get_post_option('photty_template_images') as $key => $image) {
							$counter++;
							$photoTitle = $image['caption'];
							$photoCaption = $image['description'];
							$photoAlt = $image['alt'];
							$PCREpattern = '/\r\n|\r|\n/u';
							$photoCaption = preg_replace($PCREpattern, '', nl2br($photoCaption));
							$slide_meta = wp_get_attachment_metadata($image['ID']);
							$slide_width = $slide_meta['width'];
							$slide_height = $slide_meta['height'];
							$img_ratio = $slide_width/$slide_height;
							?>
							<div class="photty_ribbon_slide photty_ribbon_slide<?php echo esc_attr($counter); ?> photty_preload_slide" data-count="<?php echo esc_attr($counter); ?>" 
								data-title = "<?php echo photty_output($photoTitle); ?>" 
                                data-ratio="<?php echo esc_attr($img_ratio); ?>" 
								data-descr = "<?php echo photty_output($photoCaption); ?>"
								data-src= "<?php echo esc_url($image['full_url']); ?>">
								<img src="<?php echo esc_url($image['full_url']); ?>" alt="<?php echo esc_attr($photoAlt); ?>"/>
								<div class="photty_ribbon_overlay"></div>
							</div>
							<?php
						}
					}
					?>
				</div>
				<div class="photty_ribbon_title_wrapper">
					<h2 class="photty_ribbon_title">&nbsp;</h2>
					<div class="photty_ribbon_caption">&nbsp;</div>
				</div>
				<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_ribbon_btn_prev"></a>
				<?php if (photty_get_post_option('photty_slider_autoplay') == 'yes' && (photty_get_post_option('photty_slider_interval') !== '' && photty_get_post_option('photty_slider_interval') > 0)) {?>
				<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_ribbon_btn_play photty_state_pause"></a>
				<?php } ?>
				<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_ribbon_btn_next"></a>
				<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_ribbon_btn_fullview"></a>
			</div>
	<?php
	
	get_footer('empty');
} else {
    get_header('gallery');
	phottyHelper::getInstance()->addJSToFooter('protected_page', '
		jQuery("html").addClass("photty_transparent_header photty_height_100");
		jQuery("body").css("background-image", "url(' . get_theme_mod('protected_bg_image', get_template_directory_uri() . '/img/null.png') . ')").addClass("photty_password_protected");
	');
    ?>

    <div class="photty_password_container">
        <div class="photty_password_form container">
            <?php the_content(); ?>
        </div>
    </div>

    <?php
    get_footer('empty');
}