<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
 * Template Name: Fullscreen SlideShow
*/
if (!post_password_required()) {
	
	the_post();
	get_header();
	$autoplay = 'no';
	$interval = '';
	$photty_fit_style = photty_get_post_option('photty_slider_fit_style');
	$photty_nav_style = photty_get_post_option('photty_slider_nav_style');
	$thmb_html = '';
	
	if (photty_get_post_option('photty_slider_autoplay') == 'yes') {
		$autoplay = 'yes';
		if (photty_get_post_option('photty_slider_interval') !== '' && photty_get_post_option('photty_slider_interval') > 0) {
			$interval = photty_get_post_option('photty_slider_interval');
		}
	}
	?>
			<div class="photty_fullscreen_slider_wrapper">
				<div class="photty_fullscreen_slider fade wait4load <?php echo esc_attr($photty_fit_style); ?>" data-nav="<?php echo esc_attr($photty_nav_style); ?>" data-autoplay="<?php echo esc_attr($autoplay); ?>" data-interval="<?php echo esc_attr($interval); ?>">
					<?php
					$counter = 0;
					if (is_array(photty_get_post_option('photty_template_images'))) {
						foreach (photty_get_post_option('photty_template_images') as $key => $image) {
							$counter++;
							$photoTitle = $image['caption'];
							$photoCaption = $image['description'];
							$photoAlt = $image['alt'];
							$PCREpattern = '/\r\n|\r|\n/u';
							$photoCaption = preg_replace($PCREpattern, '', nl2br($photoCaption));
							?>
							<div class="photty_fullscreen_slide photty_fullscreen_slide<?php echo esc_attr($counter); ?> photty_preload_slide" data-count="<?php echo esc_attr($counter); ?>"
								data-title = "<?php echo photty_output($photoTitle); ?>" 
								data-descr = "<?php echo photty_output($photoCaption); ?>"
								data-src = "<?php echo esc_url($image['full_url']); ?>">
							</div>
							<?php
							$thmb_html .= '
								<div class="photty_fullscreen_thmb photty_fullscreen_thmb'.esc_attr($counter)  .'" data-count="'. esc_attr($counter) .'">
									<img src="'. aq_resize(esc_url($image['full_url']), '160', '160', true, true, true) .'" alt="'. esc_attr($photoAlt) .'"/>
								</div>
							';
						}
					}
					?>
				</div>
				<div class="photty_slideshow_title_wrapper">
					<h2 class="photty_slideshow_title">&nbsp;</h2>
					<div class="photty_slideshow_caption">&nbsp;</div>
				</div>
				<?php if (photty_get_post_option('photty_slider_autoplay') == 'yes' && (photty_get_post_option('photty_slider_interval') !== '' && photty_get_post_option('photty_slider_interval') > 0)) {?>
					<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_fullscreen_play_pause"></a>
				<?php } ?>
				<?php if ($photty_nav_style == 'arrows') { ?>
					<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_fullscreen_slider_prev"></a>
					<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_fullscreen_slider_next"></a>
					<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_fullscreen_controls_toggler"></a>
				<?php } ?>
				<?php if ($photty_nav_style == 'thumbs') { ?>
					<div class="photty_fullscreen_thumbs_wrapper">
						<?php echo photty_output($thmb_html); ?>
					</div>
				<?php } ?>
			</div>
	<?php
	
	get_footer('empty');
} else {
    get_header('gallery');
	phottyHelper::getInstance()->addJSToFooter('protected_page', '
		jQuery("html").addClass("photty_transparent_header photty_height_100");
		jQuery("body").css("background-image", "url(' . get_theme_mod('protected_bg_image', get_template_directory_uri() . '/img/null.png') . ')").addClass("photty_password_protected");
	');
    ?>

    <div class="photty_password_container">
        <div class="photty_password_form container">
            <?php the_content(); ?>
        </div>
    </div>

    <?php
    get_footer('empty');
}