<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
 * Template Name: Albums Listing
*/
if (!post_password_required()) {
	
	the_post();
	get_header();
	$posts_first_load = photty_get_post_option('photty_albums_on_start');
	$items_per_load = photty_get_post_option('photty_albums_per_load');
	$button_title = photty_get_post_option('photty_load_more_text');
	$categs = photty_get_post_option('photty_albums_taxonomy');
	
	$selected_categories = '';
	
	if (isset($categs) && !empty($categs)) {
		foreach ($categs as $item) {
			$selected_categories .= $item->term_id . ',';
		}
	}
	$post_type_terms = array();
	if (isset($selected_categories) && strlen($selected_categories) > 0) {
		$selected_categories = substr($selected_categories, 0, -1);
		$post_type_terms = explode(",", $selected_categories);
	}

	$args = array(
		'post_type' => 'albums',
		'post_status' => 'publish',
		'posts_per_page' => absint($posts_first_load),
		'paged' => -1,
		'tax_query' => array(
			'taxonomy' => 'albumscat',
			'field' => 'id',
			'terms' => $post_type_terms			
		)
	);

	$args['tax_query'] = array(
		array(
			'taxonomy' => 'albumscat',
			'field' => 'id',
			'terms' => $post_type_terms
		)
	);

	$set_query_args = '{"output_template" : "albums_listing_template", "ajax_callback_function" : "photty_albums_listing_setup", "post_type" : "albums", "post_status" : "publish", "posts_first_load" : '. $posts_first_load .', "posts_per_page" : '. $items_per_load .', "offset" : 0, "taxonomy" : "albumscat", "field" : "id", "terms" : "' . $selected_categories . '"}';
	
	?>
			<div class="photty_albums_listing_wrapper">
				<div class="photty_albums_listing_inner">
				</div>
			</div>
	<?php
	$html = '
	<div class="albums_listing_loadmore_wrapper">
		<a class="photty_albums_load_more photty_button photty_ajax_query_posts" data-args=\''. $set_query_args .'\' data-return-to="photty_albums_listing_inner" href="'. esc_js("javascript:void(0)") .'">' . esc_attr($button_title) . '</a>
	</div>
	';
	
	echo photty_output($html);
	
	get_footer();
} else {
    get_header('gallery');
	phottyHelper::getInstance()->addJSToFooter('protected_page', '
		jQuery("html").addClass("photty_transparent_header photty_height_100");
		jQuery("body").css("background-image", "url(' . get_theme_mod('protected_bg_image', get_template_directory_uri() . '/img/null.png') . ')").addClass("photty_password_protected");
	');
    ?>

    <div class="photty_password_container">
        <div class="photty_password_form container">
            <?php the_content(); ?>
        </div>
    </div>

    <?php
    get_footer('empty');
}