<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
 * Template Name: Albums Slider
*/
if (!post_password_required()) {
	
	the_post();
	get_header();
	$posts_first_load = photty_get_post_option('photty_albums_on_start');
	$items_per_load = photty_get_post_option('photty_albums_per_load');
	$button_title = photty_get_post_option('photty_load_more_text');
	$categs = photty_get_post_option('photty_albums_taxonomy');

	$args = array(
		'post_type' => 'albums',
		'post_status' => 'publish',
		'posts_per_page' => -1,
		'paged' => -1
	);

	$selected_categories = '';	
	if (isset($categs) && !empty($categs)) {
		foreach ($categs as $item) {
			$selected_categories .= $item->term_id . ',';
		}
	}
	$post_type_terms = array();

	if (isset($selected_categories) && strlen($selected_categories) > 0) {
		$selected_categories = substr($selected_categories, 0, -1);
		$post_type_terms = explode(",", $selected_categories);
		$args['tax_query'] = array(
			array(
				'taxonomy' => 'albumscat',
				'field' => 'id',
				'terms' => $post_type_terms
			)
		);
	}
	
	
	?>
			<div class="photty_albums_slider_wrapper">
				<div class="photty_albums_slider_inner">
					<?php
					$count_in_slide = 0;
					$slide_count = 1;
					query_posts($args);
					if (have_posts()) {
						while (have_posts()) {
							the_post();
							$count_in_slide++;
							if ($count_in_slide > 3) {
								$count_in_slide = 1;
								$slide_count++;
							}
							
							$galCateg = '';
							$new_term_list = get_the_terms(get_the_id(), "albumscat");
							if (is_array($new_term_list)) {
								foreach ($new_term_list as $term) {
									$galCateg .= $term->name . " / ";
								}
							} else {
								$galCateg = 'Uncategorized  ';
							}
							$galCateg = substr($galCateg, 0, -2);
							
							?>
							<div class="photty_albums_slide photty_albums_slide<?php echo esc_attr($slide_count); ?> photty_albums_slide_item<?php echo esc_attr($count_in_slide); ?>" data-count="<?php echo esc_attr($slide_count); ?>">
								<div class="photty_albums_slide_inner photty_js_bg_image" data-src="<?php echo photty_get_featured_image_url(); ?>">
									<div class="photty_albums_slide_content">
										<h5 class="photty_albums_slide_title"><?php echo get_the_title(); ?></h5>
										<div class="photty_albums_slide_categ"><?php echo esc_attr($galCateg); ?></div>
									</div>
									<a href="<?php echo get_permalink(); ?>"></a>
								</div>
							</div>
							<?php
						}
					}
					?>
				</div>
				<div data-slides="<?php echo esc_attr($slide_count); ?>" class="photty_albums_slider_meta"></div>
			</div>
			<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_albums_btn_prev"></a>
			<a href="<?php echo esc_js("javascript:void(0)"); ?>" class="photty_albums_btn_next"></a>
			
	<?php
	get_footer('empty');
} else {
    get_header('gallery');
	phottyHelper::getInstance()->addJSToFooter('protected_page', '
		jQuery("html").addClass("photty_transparent_header photty_height_100");
		jQuery("body").css("background-image", "url(' . get_theme_mod('protected_bg_image', get_template_directory_uri() . '/img/null.png') . ')").addClass("photty_password_protected");
	');
    ?>

    <div class="photty_password_container">
        <div class="photty_password_form container">
            <?php the_content(); ?>
        </div>
    </div>

    <?php
    get_footer('empty');
}