/*
 * Split Slider
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
"use strict";

(function( $ ){
	var photty_split_object = {},
		$photty_split_wrapper = jQuery('.photty_split_showcase_wrapper'),
		lastChange = +new Date();

	photty_split_object.id = $photty_split_wrapper.attr('data-id');
	photty_split_object.obj = $photty_split_wrapper;
	photty_split_object.slider = $photty_split_wrapper.find('.photty_split_showcase');
	photty_split_object.active_left = 0;
	photty_split_object.active_right = 0;
	photty_split_object.max_left = $photty_split_wrapper.find('.photty_left_slide').length;
	photty_split_object.max_right = $photty_split_wrapper.find('.photty_right_slide').length;
	photty_split_object.state = 'loading';

	photty_split_object.init = function() {
		photty_html.addClass('photty_split_gallery_page').addClass('photty_transparent_header');
		var this_obj = this;
		this.setup(this,'');
		if (this.active_slide == 0) 
			this.change.call(this,1);
		
		this.left_slides = [];
		this.obj.find('.photty_left_slide').each(function(){
			this_obj.left_slides[jQuery(this).attr('data-count')] = {};
			this_obj.left_slides[jQuery(this).attr('data-count')].src = jQuery(this).attr('data-src');
			this_obj.left_slides[jQuery(this).attr('data-count')].html = jQuery(this).html();
		});
		
		this.right_slides = [];
		this.obj.find('.photty_right_slide').each(function(){
			this_obj.right_slides[jQuery(this).attr('data-count')] = {};
			this_obj.right_slides[jQuery(this).attr('data-count')].src = jQuery(this).attr('data-src');
			this_obj.right_slides[jQuery(this).attr('data-count')].html = jQuery(this).html();
		});
		
		this.obj.find('.photty_left_slide').remove();
		this.obj.find('.photty_right_slide').remove();
        
		// Slides Init
		this.active_left = 1;
		this.active_right = 1;
		var $this_slider = this.slider;
		var before_slide_left, active_slide_left, after_slide_left, after_slide_left_count = 2;
		if (this.max_left < 2)
			after_slide_left_count = 1;
		before_slide_left = '\
		<div class="photty_left_slide photty_split_before photty_split_slide" data-count="'+ this.max_left +'" style="background-image:url('+ this.left_slides[this.max_left].src +')">\
			'+ this.left_slides[this.max_left].html +'\
		</div>';
		active_slide_left = '\
		<div class="photty_left_slide photty_split_active photty_split_slide" data-count="1" style="background-image:url('+ this.left_slides[1].src +')">\
			'+ this.left_slides[1].html +'\
		</div>';
		after_slide_left = '\
		<div class="photty_left_slide photty_split_after photty_split_slide" data-count="'+ after_slide_left_count +'" style="background-image:url('+ this.left_slides[after_slide_left_count].src +')">\
			'+ this.left_slides[after_slide_left_count].html +'\
		</div>';
		$this_slider.append(before_slide_left).append(active_slide_left).append(after_slide_left);

		var before_slide_right, active_slide_right, after_slide_right, after_slide_right_count = 2;
		if (this.max_right < 2)
			after_slide_right_count = 1;
		before_slide_right = '\
		<div class="photty_right_slide photty_split_before photty_split_slide" data-count="'+ this.max_right +'" style="background-image:url('+ this.right_slides[this.max_right].src +')">\
			'+ this.right_slides[this.max_right].html +'\
		</div>';
		active_slide_right = '\
		<div class="photty_right_slide photty_split_active photty_split_slide" data-count="1" style="background-image:url('+ this.right_slides[1].src +')">\
			'+ this.right_slides[1].html +'\
		</div>';
		after_slide_right = '\
		<div class="photty_right_slide photty_split_after photty_split_slide" data-count="'+ after_slide_right_count +'" style="background-image:url('+ this.right_slides[after_slide_right_count].src +')">\
			'+ this.right_slides[after_slide_right_count].html +'\
		</div>';
		$this_slider.append(before_slide_right).append(active_slide_right).append(after_slide_right);
		
		// Touch and Click Events
		this.obj.on("swipeleft", function () {
			photty_split_object.change.call(photty_split_object,1);
		});
		this.obj.on("swipeup", function () {
			photty_split_object.change.call(photty_split_object,1);
		});
		this.obj.on("swiperight", function () {
			photty_split_object.change.call(photty_split_object,-1);
		});
		this.obj.on("swipedown", function () {
			photty_split_object.change.call(photty_split_object,-1);
		});

		jQuery('.photty_split_btn_prev').on('click', function(){
			photty_split_object.change.call(photty_split_object,-1);
		});
		jQuery('.photty_split_btn_next').on('click', function(){
			photty_split_object.change.call(photty_split_object,1);
		});
		
		this.obj.on('mousewheel', function(event) {
			event.preventDefault();
			if(+new Date() - lastChange > 100){
				var half_screen = photty_window.width()/2;
				if (event.deltaY < 0) {
					if (event.pageX <= half_screen) {
						photty_split_object.change.call(photty_split_object,1);
					} else {
						photty_split_object.change.call(photty_split_object,-1);
					}
				}
				if (event.deltaY > 0) {
					if (event.pageX <= half_screen) {
						photty_split_object.change.call(photty_split_object,-1);
					} else {
						photty_split_object.change.call(photty_split_object,1);
					}
				}
				lastChange = +new Date();
			} else {
				lastChange = +new Date();
			}
		});	
		
		// Window Events
		jQuery(window).on('load', function(){
			photty_split_object.obj.removeClass('photty_module_loading');
			photty_split_object.setup.call(photty_split_object,'');
		});
		jQuery(window).on('resize', function(){
			photty_split_object.setup.call(photty_split_object,'');
		});
	}
	
	photty_split_object.setup = function(action) {
		switch (action) {
			default:
				if (photty_window.height() > photty_window.width()) {
					jQuery('.photty_split_wrapper').addClass('photty_horizontal_split');
				} else {
					jQuery('.photty_split_wrapper').removeClass('photty_horizontal_split');
				}
				
				if (this.obj.hasClass('photty_single_gallery_split')) {
					var this_height = photty_window.height();
					if (jQuery('#wpadminbar').length) {
						this_height = this_height - jQuery('#wpadminbar').height();
					}
					this.obj.height(this_height);
				} else if (this.obj.hasClass('auto_height')) {
					var $this_column_wrap = this.obj.parents('.elementor-column-wrap'),
						this_height = this.obj.parents('section.elementor-element').children('.elementor-container').height() - parseInt($this_column_wrap.css('padding-top'),10) - parseInt($this_column_wrap.css('padding-bottom'),10);
					this.obj.height(this_height);
				}
				if (this.obj.hasClass('screen_height')) {
					var this_height = photty_window.height();
					if (jQuery('#wpadminbar').size() > 0) {
						this_height = this_height - jQuery('#wpadminbar').height();
					}
					if (this.obj.attr('data-header') == 'yes') {
						this_height = this_height - jQuery('header.photty_main_header').height();
					}
					if (this.obj.attr('data-footer') == 'yes') {
						this_height = this_height - jQuery('footer.photty_footer').height();
					}
					this_height = Math.ceil(this_height);
					this.obj.height(this_height);
				}
		}
	}

	photty_split_object.fix_item = function(check_item,side) {
		if(side == 'left') 
			var max_count = this.max_left;
		if(side == 'right') 
			var max_count = this.max_right;
		
		if (check_item < 1)
			check_item = max_count;
		if (check_item > max_count)
			check_item = 1;

		return check_item;
	}
	
	photty_split_object.change = function(dir) {
		var this_obj = this;
		if (dir > 0) {
			this.obj.find('.photty_split_before').remove();
			this.obj.find('.photty_split_active').removeClass('photty_split_active').addClass('photty_split_before');
			this.obj.find('.photty_split_after').removeClass('photty_split_after').addClass('photty_split_active');
			
			this.active_left++;
			this.active_right++;
			this.active_left = this.fix_item.call(this_obj, this_obj.active_left, 'left');
			this.active_right = this.fix_item.call(this_obj, this_obj.active_right, 'right');
			
			var left_after = parseInt(this.active_left,10) + 1,
				right_after = parseInt(this.active_right,10) + 1;
			left_after = this.fix_item.call(this_obj, left_after, 'left');
			right_after = this.fix_item.call(this_obj, right_after, 'right');
			
			var append_left = '\
				<div class="photty_left_slide photty_split_after photty_split_slide" data-count="'+ left_after +'" style="background-image:url('+ this.left_slides[left_after].src +')">\
					'+ this.left_slides[left_after].html +'\
				</div>';
			var append_right = '\
				<div class="photty_right_slide photty_split_after photty_split_slide" data-count="'+ right_after +'" style="background-image:url('+ this.right_slides[right_after].src +')">\
					'+ this.right_slides[right_after].html +'\
				</div>';
			
			this.slider.append(append_left).append(append_right);
		}
		if (dir < 0) {
			this.obj.find('.photty_split_after').remove();
			this.obj.find('.photty_split_active').removeClass('photty_split_active').addClass('photty_split_after');
			this.obj.find('.photty_split_before').removeClass('photty_split_before').addClass('photty_split_active');
			
			this.active_left--;
			this.active_right--;
			this.active_left = this.fix_item.call(this, this.active_left, 'left');
			this.active_right = this.fix_item.call(this, this.active_right, 'right');
			
			var left_before = this.active_left - 1,
				right_before = this.active_right - 1;
			left_before = this.fix_item.call(this, left_before, 'left');
			right_before = this.fix_item.call(this, right_before, 'right');
			
			var append_left = '\
				<div class="photty_left_slide photty_split_before photty_split_slide" data-count="'+ left_before +'" style="background-image:url('+ this.left_slides[left_before].src +')">\
					'+ this.left_slides[left_before].html +'\
				</div>';
			var append_right = '\
				<div class="photty_right_slide photty_split_before photty_split_slide" data-count="'+ right_before +'" style="background-image:url('+ this.right_slides[right_before].src +')">\
					'+ this.right_slides[right_before].html +'\
				</div>';
			
			this.slider.append(append_left).append(append_right);
		}
	}
	
	photty_split_object.load = function() {
		if (jQuery('.photty_split2preload:first').length) {
			(function (img, src) {
				img.src = src;
				img.onload = function () {
					jQuery('.photty_split2preload:first').removeClass('photty_split2preload').animate({
						'z-index': '3'
					}, 10, function() {
						photty_split_object.load.call();
					});
				};
			}(new Image(), jQuery('.photty_split2preload:first').attr('data-src')));
		} else {
			jQuery('.photty_split_wrapper').removeClass('photty_module_loading');
			photty_split_object.init.apply(photty_split_object);
		}
	}

	jQuery(document.documentElement).keyup(function (event) {
		if ((event.keyCode == 37 || event.keyCode == 38)) {
			event.preventDefault();
			photty_split_object.change.call(photty_split_object,-1);
		}
		if ((event.keyCode == 39 || event.keyCode == 40)) {
			event.preventDefault();
			photty_split_object.change.call(photty_split_object,1);
		}
	});

	jQuery(document).ready(function(){
		photty_split_object.load.apply(photty_split_object);
	});

})( jQuery );