/* SORTING */

"use strict";
var $photty_container = jQuery('.photty_grid_inner'),
	photty_grid_array = [],
	$photty_grid_gallery_array = jQuery('.photty_grid_gallery_array'),
	$photty_grid_wrapper = jQuery('.photty_grid_wrapper');

$photty_grid_wrapper.each(function() {
	var $this_obj = jQuery(this);
	photty_grid_array["photty_grid_" + $this_obj.attr('data-uniqid')] = {};
	var this_array = photty_grid_array["photty_grid_" + $this_obj.attr('data-uniqid')];
	this_array.id = jQuery(this).attr('data-uniqid');
	this_array.showed = 0;
	this_array.items = [];
	
	var this_items_array = this_array.items;
	if ($this_obj.find('.photty_grid_gallery_array').length) {
		$this_obj.find('.photty_grid_gallery_array').each(function() {
			jQuery(this).find('.photty_grid_array_item').each(function() {
				var $this = jQuery(this),
					photty_grid_item = {};
				photty_grid_item.slide_type = $this.attr('data-type');
				photty_grid_item.img = $this.attr('data-img');
				photty_grid_item.thmb = $this.attr('data-thmb');
				photty_grid_item.title = $this.attr('data-title');
				photty_grid_item.alt = $this.attr('data-alt');
				photty_grid_item.overlay = $this.attr('data-overlay');
				photty_grid_item.counter = $this.attr('data-counter');
				photty_grid_item.size = $this.attr('data-size');
				this_items_array.push(photty_grid_item);
			});
			jQuery(this).remove();
		});
	}
	this_array.obj = jQuery('.photty_grid_'+this_array.id);
    
	this_array.init = function () {
		var this_obj = this;

        if (jQuery('.photty_isotope_trigger').size() > 0) {
            if (jQuery('.photty_isotope_trigger').hasClass('is_masonry')) {
                jQuery('.photty_isotope_trigger').isotope({
                    layoutMode: 'masonry'
                });
            } else {
                jQuery('.photty_isotope_trigger').isotope({
                    layoutMode: 'fitRows'
                });
            }
        }
        
		this.obj.find('.grid_load_more').on("click", function () {
			this_obj.loadmore.call(this_obj);
		});
		this.setup.call(this);
		this.preloader.call(this);
	}
	
	this_array.preloader = function() {
		var this_obj = this,
			$this_dom = this.obj;
        $this_dom.find('.photty_grid_inner').isotope('layout');
		if ($this_dom.find('.load_anim:first').size() > 0) {
            (function (img, src) {
                img.src = src;
                img.onload = function () {
                    jQuery('.load_anim:first').removeClass('load_anim').removeClass('anim_el').animate({
                        'z-index': '15'
                    }, 200, function() {
                        this_obj.preloader.call(this_obj);
                    });
                };
            }(new Image(), jQuery('.load_anim:first').find('img').attr('src')));
		} else {
			this_obj.setup.call(this_obj);
		}
	}
	
	this_array.setup = function() {
		var this_obj = this,
			$this_dom = this.obj;
		if ($this_dom.find('.photty_js_bg_color').length) {
			$this_dom.find('.photty_js_bg_color').each(function () {
				jQuery(this).css('background-color', jQuery(this).attr('data-bgcolor'));
			});
		}
        
		var side_padding = Math.floor(parseInt($this_dom.find('.photty_grid_inner').attr('data-pad'))/2,10);
		if (photty_window.width() < 1200 && side_padding > 20) {
			side_padding = side_padding/2;
		}
		if (photty_window.width() < 760 && side_padding > 10) {
			side_padding = 10;
		}
		if (jQuery('.photty_single_gallery_grid').length) {
			$this_dom.find('.photty_grid_inner').css('margin', side_padding+'px').css('margin-bottom', '0px');
			jQuery('.photty_single_gallery_grid').css('padding-bottom', side_padding+'px');
		} else {
			$this_dom.find('.photty_grid_inner').css('margin', side_padding+'px').css('margin-top', -1*side_padding+'px');
		}
		if ($this_dom.find('.photty_grid_inner').hasClass('side_paddings_on')) {
			$this_dom.find('.photty_grid_inner').css('margin-left', -1*side_padding+'px').css('margin-right', -1*side_padding+'px');
		}
		$this_dom.find('.grid-item-inner').css({
			'margin-left' : side_padding+'px',
			'margin-top' : side_padding+'px',
			'margin-right' : side_padding+'px',
			'margin-bottom' : side_padding+'px'
		});
		$this_dom.find('.photty_grid_inner').isotope('layout');
		setTimeout("jQuery('.photty_grid_inner').isotope('layout')",1000);
	}
							   
	this_array.loadmore = function() {
		var this_obj = this,
			$this_dom = this.obj,
			photty_what_to_append = '',		
			photty_grid_post_per_page = $this_dom.attr('data-perload'),
			photty_uniqid = this.id,
			photty_allposts = this.items.length,
			photty_count = $this_dom.find('.grid-item').size(),
			photty_ins_container = $this_dom.find('.photty_grid_inner'),
			photty_load_more_button = $this_dom.find('.grid_load_more'),
            photty_overlay = photty_ins_container.attr('data-overlay');
	
		if (this.showed >= photty_allposts) {
			photty_load_more_button.slideUp(300);
		} else {
			var photty_now_step = this.showed + parseInt(photty_grid_post_per_page) - 1;
			if ((photty_now_step + 1) < photty_allposts) {
				var photty_limit = photty_now_step;
			} else {
				var photty_limit = photty_allposts - 1;
				photty_load_more_button.slideUp(300);
			}
			
			var photty_swipebox_class = '';
			if (jQuery('.photty_single_gallery_wrapper ').size() > 0) {
				photty_swipebox_class = 'swipebox';
			}
			for (var i = this.showed; i <= photty_limit; i++) {
				var photty_thishref = this.items[i].img,
				photty_what_to_append = photty_what_to_append +'\
				<div class="grid-item element anim_el anim_el2 load_anim grid_b2p">\
                    <div class="grid-item-inner">\
                        <a href="' + photty_thishref +'" class="swipebox" rel="grid_gallery'+ this.id +'" title="'+ this.items[i].title +'"></a>\
                        <img src="'+ this.items[i].thmb +'" alt="' + this.items[i].alt + '" class="grid_thmb"/>\
                        <div class="grid_overlay" style="background-color:'+ photty_overlay +'"></div>\
                        <div class="photty-img-preloader"></div>\
                    </div>\
				</div>';
                
				photty_count++;
				this.showed++;
			}

			var $photty_newItems = jQuery(photty_what_to_append);

			if (photty_ins_container.data('isotope')) {
				photty_ins_container.isotope('insert', $photty_newItems, function() {
                    photty_ins_container.isotope('layout');
				});
			}
            photty_ins_container.isotope('layout');
            this_obj.preloader.call(this_obj);
			this_obj.setup.call(this_obj);
		}
		jQuery('.photty_grid_inner').isotope("layout");
	}
    
});

if (jQuery('.photty_grid_inner').size() > 0) {
	var $photty_container = jQuery('.photty_grid_inner');
}

jQuery(document).ready(function(){
	$photty_grid_wrapper.each(function() {
		var $this_obj = jQuery(this),
			this_obj = photty_grid_array["photty_grid_" + $this_obj.attr('data-uniqid')];
		this_obj.init.call(this_obj);
	});
});

jQuery(window).load(function () {
	$photty_grid_wrapper.each(function() {
		var $this_obj = jQuery(this),
			this_obj = photty_grid_array["photty_grid_" + $this_obj.attr('data-uniqid')];
		this_obj.setup.call(this_obj);
	});
});

jQuery(window).resize(function () {
	$photty_grid_wrapper.each(function() {
		var $this_obj = jQuery(this),
			this_obj = photty_grid_array["photty_grid_" + $this_obj.attr('data-uniqid')];
		this_obj.setup.call(this_obj);
	});
});