/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
"use strict";

var	photty_fullscreen_slider_array = [],
    $photty_slider_wrapper = jQuery('.photty_fullscreen_slider_wrapper');

$photty_slider_wrapper.each(function(){
    var $this_obj = jQuery(this);
    photty_fullscreen_slider_array['photty_slider_' + $this_obj.attr('data-uniqid')] = {};
    var this_array = photty_fullscreen_slider_array["photty_slider_" + $this_obj.attr('data-uniqid')];        
    this_array.id = $this_obj.attr('data-uniqid');
    this_array.dom = $this_obj;
    this_array.slider = $this_obj.find('.photty_fullscreen_slider');
    this_array.active_slide = 0;
    this_array.max = $this_obj.find('.photty_fullscreen_slide').length;
    if (this_array.slider.attr('data-nav') == 'thumbs') {
        this_array.nav = 'thumbs';
        this_array.thumbs = this_array.dom.find('.photty_fullscreen_thumbs_wrapper');
        if (this_array.max < 5) {
            this_array.thumbs.addClass('.photty_three_thumbs');
        }
    } else {
        this_array.nav = 'arrows';
    }
    this_array.content_obj = this_array.dom.find('.photty_slideshow_title_wrapper');
    this_array.title_obj = this_array.dom.find('.photty_slideshow_title');
    this_array.descr_obj = this_array.dom.find('.photty_slideshow_caption');
    
    // Options
    this_array.autoplay = this_array.slider.attr('data-autoplay');
    this_array.interval = this_array.slider.attr('data-interval');

    // Init
    this_array.init = function() {
        var this_obj = this;
        this.layout(this,'');

        if (this_array.nav == 'thumbs') {
            photty_html.addClass('photty_slider_w_thumbs').addClass('photty_fullscreen_slider').addClass('photty_transparent_header');
        } else {
            photty_html.addClass('photty_slider_w_arrows').addClass('photty_fullscreen_slider').addClass('photty_transparent_header');
        }
		if (this_obj.max == 1) {
			// Only One Image
			this_obj.dom.addClass('photty_only_one_image_slider photty_simple_slider_started');
			this_obj.dom.find('.photty_simple_slide1').addClass('active simple_slide_loaded').removeClass('simple_slide_loader');
            this_array.active_slide = 1;
		}
        
        this_obj.dom.find('.photty_preload_slide').each(function() {
           var $this = jQuery(this);
            $this.removeClass('photty_preload_slide');
            $this.attr('style', 'background:url(' + $this.attr('data-src') + ') no-repeat;');
        });
        
        // Bind Events        
        this_obj.dom.on('mouseenter',function(){
            this_obj.dom.addClass('photty_slider_kbrd');
        });
        this_obj.dom.on('mouseleave',function(){
            this_obj.dom.removeClass('photty_slider_kbrd');
        });
        this_obj.dom.find('.photty_fullscreen_slider_prev').on('click',function(){
            this_obj.move.call(this_obj, -1);
        });
        this_obj.dom.find('.photty_fullscreen_slider_next').on('click',function(){
            this_obj.move.call(this_obj, 1);
        });
        this_obj.dom.find('.photty_fullscreen_controls_toggler').on('click',function(){
            photty_html.toggleClass('photty_fullscreen_fullview');
        });
		this_obj.dom.find('.photty_fullscreen_thmb').on('click', function () {
            this_obj.set.call(this_obj, jQuery(this).attr('data-count'));
		});
        this_obj.dom.find('.photty_fullscreen_play_pause').on('click', function () {
            var $this = jQuery(this);
            if ($this.hasClass('photty_state_play')) {
                clearInterval(this_obj.set_interval);
            } else {
                this_obj.set_interval = setInterval( function() {
                    this_obj.move.call(this_obj,1);
                }, parseInt(this_obj.interval,10));
            }
            $this.toggleClass('photty_state_play');
        });
		this_obj.slider.on("swipeleft", function () {
			this_obj.move.call(this_obj, 1);
		});
		this_obj.slider.on("swiperight", function () {
			this_obj.move.call(this_obj, -1);
		});
        
        this_obj.slider.addClass('started');

        // Autoplay
        if (this_obj.autoplay == 'yes' && this_obj.max > 1) {
            this_obj.state = 'playing';
            this_obj.set_interval = setInterval( function() {
                this_obj.move.call(this_obj,1);
            }, parseInt(this_obj.interval,10));
            clearInterval(this_obj.set_interval);
            this_obj.dom.find('.photty_fullscreen_play_pause').addClass('photty_state_play');
        } else {
            this_obj.state = 'paused';
        }
        this_obj.move.call(this_obj,1);
    }

    // ReLayout
    this_array.layout = function(type) {
        var this_obj = this;
        
        // Resize Slider and Slides
        var slider_height = photty_window.height(),
            slider_top = 0;
        if (jQuery('#wpadminbar').length) {
            slider_height = slider_height - jQuery('#wpadminbar').height();
            slider_top = jQuery('#wpadminbar').height();
        }
        this_obj.dom.height(slider_height);
        this_obj.slider.height(slider_height);
        this_obj.dom.css('top', slider_top+'px');
        this_obj.slider.css('top', slider_top+'px');
    }

    // Overflow Check
    this_array.check = function(check_item) {
        check_item = parseInt(check_item);
        if (check_item > this.max)
            check_item = 1;
        if (check_item < 1)
            check_item = this.max;
        
        return check_item;
    }
    
    // Move Slider
    this_array.move = function(dir) {
        var this_obj = this,
            active_slide = this_obj.active_slide;
        if (dir > 0)
            active_slide++;
        if (dir < 0)
            active_slide--;
        
        active_slide = this_obj.check.call(this_obj, active_slide);        
        this_obj.set.call(this_obj, active_slide);
    }
    
    // Set Slide
    this_array.set = function(slide_id) {
        var this_obj = this;
        slide_id = parseInt(slide_id,10);
        this_obj.active_slide = slide_id;

        if (this_obj.autoplay == 'yes' && this_obj.state == 'playing') {
            clearInterval(this_obj.set_interval);
        }

        var $active_slide = this_obj.slider.find('[data-count='+ slide_id +']');
        this_obj.slider.find('.active').removeClass('active');
        $active_slide.addClass('active');
        
        // Thumbs
        if (this_obj.nav == 'thumbs') {
            this_obj.thumbs.find('.thumb_active').removeClass('thumb_active');
            this_obj.thumbs.find('.thumb_b1').removeClass('thumb_b1');
            this_obj.thumbs.find('.thumb_n1').removeClass('thumb_n1');
            this_obj.thumbs.find('.thumb_b2').removeClass('thumb_b2');
            this_obj.thumbs.find('.thumb_n2').removeClass('thumb_n2');

            var thumb_a = slide_id, thumb_b1 = slide_id-1, thumb_n1 = slide_id+1, thumb_b2, thumb_n2;
            thumb_b1 = this_obj.check.call(this_obj, thumb_b1);
            thumb_n1 = this_obj.check.call(this_obj, thumb_n1);

            this_obj.thumbs.find('[data-count='+ thumb_b1 +']').addClass('thumb_b1');
            this_obj.thumbs.find('[data-count='+ thumb_a +']').addClass('thumb_active');
            this_obj.thumbs.find('[data-count='+ thumb_n1 +']').addClass('thumb_n1');

            if (this_obj.max > 4) {
                thumb_b2 = thumb_b1-1;
                thumb_b2 = this_obj.check.call(this_obj, thumb_b2);
                thumb_n2 = thumb_n1+1;
                thumb_n2 = this_obj.check.call(this_obj, thumb_n2);
                this_obj.thumbs.find('[data-count='+ thumb_b2 +']').addClass('thumb_b2');
                this_obj.thumbs.find('[data-count='+ thumb_n2 +']').addClass('thumb_n2');
            }
        }

        this_obj.content_obj.fadeOut(150, function () {
            this_obj.title_obj.text($active_slide.attr('data-title'));
            this_obj.descr_obj.text($active_slide.attr('data-descr'));
            this_obj.content_obj.fadeIn(150);
        });

        if (this_obj.autoplay == 'yes' && this_obj.state == 'playing') {
            this_obj.set_interval = setInterval( function() {
                this_obj.move.call(this_obj,1);
            }, parseInt(this_obj.interval,10));
        }
    };
});

jQuery(document).ready(function(){
    if ($photty_slider_wrapper.length)
        $photty_slider_wrapper.each(function(){
            var $this = jQuery(this),
                $this_array = photty_fullscreen_slider_array['photty_slider_' + $this.attr('data-uniqid')];
            $this_array.init.call($this_array);
        });
});

jQuery(window).resize(function () {
    if ($photty_slider_wrapper.length) {
        $photty_slider_wrapper.each(function(){
            var $this = jQuery(this),
                $this_array = photty_fullscreen_slider_array['photty_slider_' + $this.attr('data-uniqid')];
            $this_array.layout.call($this_array);
        });
    }
});

jQuery(document.documentElement).keyup(function (event) {
    if (jQuery('body').find('.photty_slider_kbrd').length) {
        var $this = jQuery('body').find('.photty_slider_kbrd'),
            $this_array = photty_fullscreen_slider_array['photty_slider_' + $this.attr('data-uniqid')];
        if ((event.keyCode == 37)) {
            $this_array.move.call($this_array, -1);
        }
        if ((event.keyCode == 39)) {
            $this_array.move.call($this_array, 1);
        }
    }
});