/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
"use strict";


var	photty_albums_slider_array = [],
    $photty_albums_slider_wrapper = jQuery('.photty_albums_slider_wrapper');

$photty_albums_slider_wrapper.each(function(){
    var $this_obj = jQuery(this);
    photty_albums_slider_array['photty_slider_' + $this_obj.attr('data-uniqid')] = {};
    var this_array = photty_albums_slider_array["photty_slider_" + $this_obj.attr('data-uniqid')];        
    this_array.id = $this_obj.attr('data-uniqid');
    this_array.dom = $this_obj;
    this_array.slider = $this_obj.find('.photty_albums_slider_inner');
    this_array.active_slide = 0;
    this_array.max = $this_obj.find('.photty_albums_slide:last').attr('data-count');
    this_array.header = jQuery('header.photty_header');
    this_array.meta = jQuery('.photty_albums_slider_meta');
    
    // Init
    this_array.init = function() {
        var this_obj = this;
        this.layout(this,'');

		if (this_obj.max == 1) {
			// Only One Image
            this_array.active_slide = 1;
            photty_html.addClass('only_one_slide');
		}
        
        photty_html.addClass('photty_albums_slider');
        
        // Bind Events        
        jQuery('.photty_albums_btn_prev').on('click',function(){
            this_obj.move.call(this_obj, -1);
        });
        jQuery('.photty_albums_btn_next').on('click',function(){
            this_obj.move.call(this_obj, 1);
        });
		this_obj.slider.on("swipeleft", function () {
			this_obj.move.call(this_obj, 1);
		});
		this_obj.slider.on("swiperight", function () {
			this_obj.move.call(this_obj, -1);
		});
        
        this_obj.slider.addClass('started');

        this_obj.move.call(this_obj,1);
    }

    // ReLayout
    this_array.layout = function(type) {
        var this_obj = this;
        
        // Resize Slider and Slides
        var body_height = photty_window.height(),
            slider_height = photty_window.height() - this_obj.meta.height() - this_obj.header.height(),
            slider_top = this_obj.header.height();
        
        if (jQuery('#wpadminbar').length) {
            body_height = body_height - jQuery('#wpadminbar').height();
            slider_height = slider_height - jQuery('#wpadminbar').height();
            slider_top = slider_top + jQuery('#wpadminbar').height();
        }
        
        if (photty_window.width() < 760) {
            slider_height = slider_height - this_obj.meta.height();
            slider_top = slider_top + this_obj.meta.height();
        }

        this_obj.dom.height(slider_height);
        this_obj.slider.height(slider_height);
        this_obj.dom.css('top', slider_top+'px');
        jQuery('body').height(body_height);
    }

    // Overflow Check
    this_array.check = function(check_item) {
        check_item = parseInt(check_item);
        if (check_item > this.max)
            check_item = 1;
        if (check_item < 1)
            check_item = this.max;
        
        return check_item;
    }
    
    // Move Slider
    this_array.move = function(dir) {
        var this_obj = this,
            active_slide = parseInt(this_obj.active_slide,10);
        if (dir > 0)
            active_slide++;
        if (dir < 0)
            active_slide--;
        
        active_slide = this_obj.check.call(this_obj, active_slide);
        this_obj.active_slide = active_slide;
        var slides_before = active_slide - 1,
            slides_after = active_slide + 1;
        slides_before = this_obj.check.call(this_obj, slides_before);
        slides_after = this_obj.check.call(this_obj, slides_after);

        this_obj.slider.find('.before').removeClass('before');
        this_obj.slider.find('.active').removeClass('active');
        this_obj.slider.find('.after').removeClass('after');
        
        this_obj.slider.find('[data-count='+ slides_before +']').addClass('before');
        this_obj.slider.find('[data-count='+ active_slide +']').addClass('active');
        this_obj.slider.find('[data-count='+ slides_after +']').addClass('after');
    }    
});

jQuery(document).ready(function(){
    if ($photty_albums_slider_wrapper.length)
        $photty_albums_slider_wrapper.each(function(){
            var $this = jQuery(this),
                $this_array = photty_albums_slider_array['photty_slider_' + $this.attr('data-uniqid')];
            $this_array.init.call($this_array);
        });
});

jQuery(window).resize(function () {
    if ($photty_albums_slider_wrapper.length) {
        $photty_albums_slider_wrapper.each(function(){
            var $this = jQuery(this),
                $this_array = photty_albums_slider_array['photty_slider_' + $this.attr('data-uniqid')];
            $this_array.layout.call($this_array);
        });
    }
});

jQuery(document.documentElement).keyup(function (event) {
    var $this = jQuery('body').find('.photty_slider_kbrd'),
        $this_array = photty_albums_slider_array['photty_slider_' + $this.attr('data-uniqid')];
    if ((event.keyCode == 37)) {
        $this_array.move.call($this_array, -1);
    }
    if ((event.keyCode == 39)) {
        $this_array.move.call($this_array, 1);
    }
});