"use strict";

function photty_reactivate_sortable() {
    jQuery('.photty_text_table_rows').sortable(
        {
            handle: '.photty_text_table_row_move',
        }
    );
}

function photty_rwmb_and_customizer_condition() {
    jQuery("[data-dependency-id]").each(function (index) {
        var photty_target = jQuery(this).attr('data-dependency-id');
        var photty_needed_val = jQuery(this).attr('data-dependency-val');

        if (jQuery(this).hasClass('photty_dependency_customizer')) {
            var photty_target_status = jQuery('#customize-control-' + photty_target).find('select').val();
            var photty_dependency_elem_cont = jQuery(this).parents('.customize-control');
        } else {
            var photty_target_status = jQuery('#' + photty_target).val();
            var photty_dependency_elem_cont = jQuery(this).parents('.rwmb-field');
        }

        if (photty_needed_val == photty_target_status) {
            photty_dependency_elem_cont.show('fast');
        } else {
            photty_dependency_elem_cont.hide('fast');
        }
    });
}

function photty_hide_unnecessary_options() {
    if (jQuery('.photty_this_template_file').size() > 0) {
        var photty_this_template_file = jQuery('.photty_this_template_file').val();
        jQuery("[data-template-file]").each(function (index) {
            var photty_unnecessary_target = jQuery(this).attr('data-template-file');
            if (photty_unnecessary_target.indexOf(',') > -1) {
                var photty_unnecessary_target_array = photty_unnecessary_target.split(',');
                var photty_rwmb_del_status = 'not find';
                jQuery.each(photty_unnecessary_target_array, function (i, val) {
                    if (photty_this_template_file == val.trim()) {
                        photty_rwmb_del_status = 'find';
                    }
                });
                if (photty_rwmb_del_status == 'not find') {
                    jQuery(this).parents('.rwmb-field').remove();
                }
            } else {
                if (photty_this_template_file !== photty_unnecessary_target) {
                    jQuery(this).parents('.rwmb-field').remove();
                }
            }
        });
    }
}

jQuery(document).on('change', '#post-format-selector-0', function(){
	photty_onchange_post_formats2(jQuery(this).val());
});

function photty_onchange_post_formats2(val) {
    jQuery('#image-post-format-settings, #video-post-format-settings, #audio-past-format-settings, #quote-post-format-settings, #link-post-format-settings, #gallery-post-format-settings').hide('fast');
	
	if (val == 'gallery') {
		jQuery('#gallery-post-format-settings').show('fast');
	}
	if (val == 'link') {
		jQuery('#link-post-format-settings').show('fast');
	}
	if (val == 'image') {
		jQuery('#image-post-format-settings').show('fast');
	}
	if (val == 'quote') {
		jQuery('#quote-post-format-settings').show('fast');
	}
	if (val == 'standard') {
        jQuery('#image-post-format-settings, #video-post-format-settings, #audio-past-format-settings, #quote-post-format-settings, #link-post-format-settings, #gallery-post-format-settings').hide('fast');
	}
	if (val == 'video') {
		jQuery('#video-post-format-settings').show('fast');
	}
	if (val == 'audio') {
		jQuery('#audio-past-format-settings').show('fast');
	}
}

function photty_onchange_post_formats() {
    var photty_post_format = jQuery('#post-formats-select input:checked').val();
    jQuery('#image-post-format-settings, #video-post-format-settings, #audio-post-format-settings, #quote-post-format-settings').hide('fast');
    if (photty_post_format == 'standard') {
        jQuery('#image-post-format-settings, #video-post-format-settings, #audio-post-format-settings, #quote-post-format-settings').hide('fast');
    }
    if (photty_post_format == 'image') {
        jQuery('#image-post-format-settings').show('fast');
    }
    if (photty_post_format == 'video') {
        jQuery('#video-post-format-settings').show('fast');
    }
    if (photty_post_format == 'audio') {
        jQuery('#audio-post-format-settings').show('fast');
    }
    if (photty_post_format == 'quote') {
        jQuery('#quote-post-format-settings').show('fast');
    }
	
	if (jQuery('#post-formats-select').length < 1) {
		// Body Class
		if (jQuery('body').hasClass('post-type-gallery')) {
			jQuery('#gallery-post-format-settings').show('fast');
			setTimeout("jQuery('#gallery-post-format-settings').show('fast')",100);
		} else if (jQuery('body').hasClass('post-type-image')) {
			jQuery('#image-post-format-settings').show('fast');
			setTimeout("jQuery('#image-post-format-settings').show('fast')",100);
		} else if (jQuery('body').hasClass('post-type-video')) {
			jQuery('#video-post-format-settings').show('fast');
			setTimeout("jQuery('#video-post-format-settings').show('fast')",100);
		} else if (jQuery('body').hasClass('post-type-audio')) {
			jQuery('#audio-past-format-settings').show('fast');
			setTimeout("jQuery('#audio-post-format-settings').show('fast')",100);
		} else if (jQuery('body').hasClass('post-type-quote')) {
			jQuery('#quote-post-format-settings').show('fast');
			setTimeout("jQuery('#quote-post-format-settings').show('fast')",100);
		} else if (jQuery('body').hasClass('post-type-link')) {
			jQuery('#link-post-format-settings').show('fast');
			setTimeout("jQuery('#link-post-format-settings').show('fast')",100);
		} else {
			jQuery('#image-post-format-settings, #video-post-format-settings, #audio-past-format-settings, #quote-post-format-settings, #link-post-format-settings, #gallery-post-format-settings').hide('fast');
		}
	}
}

jQuery(document).ready(function () {
    photty_onchange_post_formats();
    photty_rwmb_and_customizer_condition();
    photty_hide_unnecessary_options();

    jQuery('.rwmb-select, .customize-control-select select').change(function () {
        photty_rwmb_and_customizer_condition();
    });

    jQuery('#post-formats-select input').on("click", function () {
        photty_onchange_post_formats();
    });
    
    jQuery('.photty_reset_all_settings').on("click", function () {
	    if (confirm("Are you sure? All settings will be reset to default state.")) {
			jQuery.post(photty_admin_ajax_url, {
	            action: 'photty_reset_all_settings'
	        }, function (response) {
	            alert(response);
	        });
		}
	});

    if (jQuery('#page_template').size() > 0 && jQuery('#page_template').val() !== 'default') {
        jQuery('body').addClass(jQuery('#page_template').val().split('.')[0]);
    }

    jQuery(document).on("click", '.photty_text_table_add_row', function () {
        var photty_text_table_data_storage_name = jQuery(this).parents('.widget-content').find('.photty_text_table_data_storage_name').val();
        var photty_text_table_name_text = jQuery(this).parents('.widget-content').find('.photty_text_table_name_text').val();
        var photty_text_table_value_text = jQuery(this).parents('.widget-content').find('.photty_text_table_value_text').val();

        jQuery(this).parents('.widget-content').find('.photty_text_table_rows').append('<div class="photty_text_table_row photty_dn"><div class="photty_50_dib"><label>' + photty_text_table_name_text + ':</label><input class="widefat" type="text" name="' + photty_text_table_data_storage_name + '[][name]" value=""></div><div class="photty_50_dib"><label>' + photty_text_table_value_text + ':</label><textarea class="widefat" type="text" name="' + photty_text_table_data_storage_name + '[][value]"></textarea></div><div class="photty_text_table_row_remove"><i class="fa fa-trash"></i></div><div class="photty_text_table_row_move"><i class="fa fa-arrows"></i></div></div>');
        jQuery('.photty_dn').slideDown("fast").removeClass('photty_dn');
    });

    jQuery(document).on("click", '.photty_text_table_row_remove', function () {
        jQuery(this).parents('.photty_text_table_row').slideUp("normal", function () {
            jQuery(this).remove();
        });
    });

    jQuery(document).on("click", '.widget-control-save', function () {
        setTimeout(function () {
            photty_reactivate_sortable()
        }, 1000);
        setTimeout(function () {
            photty_reactivate_sortable()
        }, 2000);
        setTimeout(function () {
            photty_reactivate_sortable()
        }, 3000);
    });

    photty_reactivate_sortable();
});