<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge">
    <?php 
	$photty_page_featured_image = photty_get_featured_image_url(); 
	if (!empty($photty_page_featured_image) && $photty_page_featured_image !== '') {
	    echo '<meta property="og:image" content="'. $photty_page_featured_image .'" />';
	}	
	?>
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php wp_head(); ?>
</head>
<body <?php body_class(photty_get_prefered_option('content_layout', 'clean')); ?>>
<header class="photty_header <?php echo photty_get_prefered_option('logo_position', 'logo_left');
echo(get_theme_mod('sticky_header', true) == true ? ' photty_sticky_header_on' : 'photty_sticky_header_off'); ?>">
    <div class="container <?php echo(get_theme_mod('header_fw', true) == true ? 'header_fw' : 'header_boxed'); ?>">
        <div class="row">
            <div class="col-md-12 photty_def_header">
                <div class="photty_logo_cont">
                    <?php photty_the_logo(); ?>
                </div>
                <div class="photty_menu_cont">
                    <?php if (photty_get_post_option('header_menu_status', 'show') !== 'hide') {
                        $photty_menu_locations = get_nav_menu_locations();
                        if (isset($photty_menu_locations['main']) && $photty_menu_locations['main'] !== 0) {
                            wp_nav_menu(array('theme_location' => 'main', 'menu_class' => 'photty_menu', 'depth' => '3', 'container' => ''));
                        } else {
                            echo '<div class="photty_menu_notify">' . esc_html__('Please create and select menu in Appearance (Menus)', 'photty') . ' <a href="'.get_admin_url(null, 'nav-menus.php').'"><i class="fa fa-long-arrow-right" aria-hidden="true"></i></a></div>';
                        }
                    } ?>
                    <?php
					# Socials
					echo photty_show_social_icons(array(
						array(
							"uniqid" => "photty_soc_facebook",
							"class" => "facebook",
							"title" => "Facebook",
							"target" => "_blank",
						),
						array(
							"uniqid" => "photty_soc_twitter",
							"class" => "twitter",
							"title" => "Twitter",
							"target" => "_blank",
						),
						array(
							"uniqid" => "photty_soc_linkedin",
							"class" => "linkedin",
							"title" => "Linked In",
							"target" => "_blank",
						),						
						array(
							"uniqid" => "photty_soc_youtube",
							"class" => "youtube",
							"title" => "Youtube",
							"target" => "_blank",
						),
						array(
							"uniqid" => "photty_soc_instagram",
							"class" => "instagram",
							"title" => "Instagram",
							"target" => "_blank",
						),
						array(
							"uniqid" => "photty_soc_pinterest",
							"class" => "pinterest",
							"title" => "Pinterest",
							"target" => "_blank",
						),
						array(
							"uniqid" => "photty_soc_tumblr",
							"class" => "tumblr",
							"title" => "Tumblr",
							"target" => "_blank",
						),
						array(
							"uniqid" => "photty_soc_flickr",
							"class" => "flickr",
							"title" => "Flickr",
							"target" => "_blank",
						),
						array(
							"uniqid" => "photty_soc_vk",
							"class" => "vk",
							"title" => "VK",
							"target" => "_blank",
						),
						array(
							"uniqid" => "photty_soc_dribbble",
							"class" => "dribbble",
							"title" => "Dribbble",
							"target" => "_blank",
						),
						array(
							"uniqid" => "photty_soc_vimeo",
							"class" => "vimeo",
							"title" => "Vimeo",
							"target" => "_blank",
						),
						array(
							"uniqid" => "photty_soc_500px",
							"class" => "500px",
							"title" => "500px",
							"target" => "_blank",
						),
						array(
							"uniqid" => "photty_soc_snapchat",
							"class" => "snapchat-ghost",
							"title" => "Snapchat",
							"target" => "_blank",
						)
					));					
					?>
                </div>
                <div class="clear"></div>
            </div>
            <div class="mobile_header col-md-12">
                <?php photty_the_logo(); ?>
                <a href="<?php echo esc_js("javascript:void(0)");?>" class="btn_mobile_menu">
                    <span class="photty_menu_line1"></span>
                    <span class="photty_menu_line2"></span>
                    <span class="photty_menu_line3"></span>
                </a>
            </div><!-- .mobile_header -->
        </div>
    </div>
</header>