<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

# General
add_theme_support('title-tag');
add_theme_support('post-thumbnails');
add_theme_support('automatic-feed-links');
add_theme_support('post-formats', array('image', 'video', 'audio', 'quote'));

if (!isset($content_width)) {
    $content_width = 1130;
}

# ADD Localization Folder
add_action('after_setup_theme', 'photty_pomo');
function photty_pomo()
{
    load_theme_textdomain('photty', get_template_directory() . '/languages');
}

require_once(get_template_directory() . "/core/init.php");

# Admin Ajax
add_action('admin_head', 'photty_admin_ajax_url');
function photty_admin_ajax_url() {
    echo "
    <script>
        var photty_admin_ajax_url = '" . admin_url("admin-ajax.php") . "';
    </script>
    ";
}

# ADD Theme Settings Page
add_action('admin_menu', 'photty_add_menu');
function photty_add_menu()
{
    add_theme_page('Photty', 'Photty', 'administrator', 'photty_settings_page', 'photty_theme_settings_page' );
}

# Show Admin Settings Page
function photty_theme_settings_page()
{
    if (!current_user_can('manage_options')) {
        wp_die(esc_html__('You do not have permissions to access this page.', 'photty'));
    }
	echo '
    <div class="photty_admin_wrapper">
    	<h1>Hey!</h1>
	    <p>All settings of our theme are made through a standard Customizer. Click <a href="'.get_admin_url(null, 'customize.php').'">here</a> to go to the settings.</p>
	
		<p>If you want to reset all settings, feel free to click on <a href="#" class="photty_reset_all_settings">this link</a>. But remember that there is no turning back ;)</p>
	
		<p>If you have any questions, problems or want to talk - email us via the form on <a href="http://themeforest.net/user/pixel-mafia" target="_blank">this</a> page.</p>
    </div>
    ';
}

# Register CSS/JS
add_action('wp_enqueue_scripts', 'photty_css_js');
if (!function_exists('photty_css_js')) {
    function photty_css_js()
    {
        # CSS
		wp_register_style('font-awesome', get_template_directory_uri() . '/css/font-awesome.min.css');		
		wp_enqueue_style('font-awesome');
		
        wp_enqueue_style('bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css');
        wp_enqueue_style('photty-vc', get_template_directory_uri() . '/css/vc.css');
        wp_enqueue_style('photty-theme', get_template_directory_uri() . '/css/theme.css');
		wp_enqueue_style('photty-responsive', get_template_directory_uri() . '/css/responsive.css');
		if (get_post_type() == 'albums') {
			wp_enqueue_style('photty-swipebox', get_template_directory_uri() . '/css/swipebox.css');
		}
		
        if (get_page_template_slug() == 'page-split-showcase.php') {
            wp_enqueue_style('photty-swipebox', get_template_directory_uri() . '/css/swipebox.css');
        }

		if (photty_is_woocommerce_activated()) {
			wp_enqueue_style('photty-woocommerce', get_template_directory_uri() . '/css/woocommerce.css');
		}

        # JS
        wp_enqueue_script('photty-theme', get_template_directory_uri() . '/js/theme.js', array('jquery'), false, true);
		if (get_post_type() == 'albums') {			
			wp_enqueue_script('jquery_swipebox', get_template_directory_uri() . '/js/jquery.swipebox.js', true, false, true);
		}		
        if (get_page_template_slug() == 'page-split-showcase.php') {
            wp_enqueue_script('jquery_swipebox', get_template_directory_uri() . '/js/jquery.swipebox.js', true, false, true);
            wp_enqueue_script('mousewheel_js', get_template_directory_uri() . '/js/jquery.mousewheel.js', array(), false, true);
            wp_enqueue_script('photty-split-showcase', get_template_directory_uri() . '/js/split_showcase.js', array('jquery'), false, true);
        }
        if (get_page_template_slug() == 'page-fullscreen-slider.php') {
            wp_enqueue_script('photty-fullscreen-slideshow', get_template_directory_uri() . '/js/slideshow_gallery.js', array('jquery'), false, true);
            wp_enqueue_script('jquery-event-swipe', get_template_directory_uri() . '/js/jquery.event.swipe.js', array('jquery'), false, true);
        }
        if (get_page_template_slug() == 'page-ribbon-slider.php') {
            wp_enqueue_script('photty-ribbon-slider', get_template_directory_uri() . '/js/ribbon_slider.js', array('jquery'), false, true);
            wp_enqueue_script('jquery-event-swipe', get_template_directory_uri() . '/js/jquery.event.swipe.js', array('jquery'), false, true);
        }
		if (get_page_template_slug() == 'page-albums-slider.php') {
			wp_enqueue_script('jquery_albums_slider', get_template_directory_uri() . '/js/jquery_albums_slider.js', true, false, true);
			wp_enqueue_script('jquery-event-swipe', get_template_directory_uri() . '/js/jquery.event.swipe.js', array('jquery'), false, true);
		}
		if (photty_is_woocommerce_activated()) {
			wp_enqueue_script('photty-woocommerce', get_template_directory_uri() . '/js/woocommerce.js', array('jquery'), false, true);
		}

    }
}

# Register CSS/JS for Admin Settings
add_action('admin_enqueue_scripts', 'photty_admin_css_js');
if (!function_exists('photty_admin_css_js')) {
    function photty_admin_css_js()
    {
        # CSS
		wp_register_style('font-awesome', get_template_directory_uri() . '/css/font-awesome.min.css');
        wp_enqueue_style('photty-admin', get_template_directory_uri() . '/css/admin.css');
		wp_enqueue_style('font-awesome');
        # JS
        wp_enqueue_script('photty-admin', get_template_directory_uri() . '/js/admin.js', array('jquery', 'jquery-ui-core', 'jquery-ui-sortable'), false, true);
    }
}

# WP Footer
add_action('wp_footer', 'photty_wp_footer');
function photty_wp_footer()
{
    phottyHelper::getInstance()->echoFooter();
}

# Register Menu
add_action('init', 'photty_register_menu');
function photty_register_menu()
{
    register_nav_menus(
        array(
            'main' => esc_attr__('Main menu', 'photty')
        )
    );
}

# Logo
function photty_the_logo($position = 'header')
{
    if ($position == 'header') {
        $prefix = '';
    }
    if ($position == 'footer') {
        $prefix = 'footer_';
    }
    if (get_theme_mod($prefix . 'logo_type', 'image_logo') == 'image_logo') {
        echo '<a href="' . esc_url(home_url('/')) . '" class="photty_image_logo ' . (get_theme_mod($prefix . 'logo_retina', true) == true ? 'photty_retina' : '') . '"></a>';
    } else {
        echo '<div class="photty_text_logo"><a href="' . esc_url(home_url('/')) . '">' . get_theme_mod($prefix . 'logo_text_caption', 'Text Logo') . '</a></div>';
    }
}

# Hex 2 RGB
function photty_hex2rgb($hex)
{
    $hex = str_replace("#", "", $hex);

    if (strlen($hex) == 3) {
        $r = hexdec(substr($hex, 0, 1) . substr($hex, 0, 1));
        $g = hexdec(substr($hex, 1, 1) . substr($hex, 1, 1));
        $b = hexdec(substr($hex, 2, 1) . substr($hex, 2, 1));
    } else {
        $r = hexdec(substr($hex, 0, 2));
        $g = hexdec(substr($hex, 2, 2));
        $b = hexdec(substr($hex, 4, 2));
    }
    return $r . "," . $g . "," . $b;
}

# Register Sidebars
add_action('widgets_init', 'photty_widgets_init');
function photty_widgets_init()
{
    register_sidebar(
        array(
            'name' => esc_attr__('Sidebar', 'photty'),
            'id' => 'sidebar',
            'description' => esc_attr__('Widgets in this area will be shown on all posts and pages.', 'photty'),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h6 class="widgettitle">',
            'after_title' => '</h6>',
        )
    );

    register_sidebar(
        array(
            'name' => esc_attr__('Footer Sidebar', 'photty'),
            'id' => 'footer',
            'description' => esc_attr__('Widgets in this area will be shown on all posts and pages.', 'photty'),
            'before_widget' => '<div id="%1$s" class="col-md-' . (get_theme_mod('footer_widgets_in_row', '4') == '4' ? '3' : '4') . ' col-sm-6 col-xs-12 widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h6 class="widgettitle">',
            'after_title' => '</h6>',
        )
    );

    if (photty_is_woocommerce_activated()) {
        register_sidebar(
            array(
                'name' => esc_attr__('Sidebar Woocommerce', 'photty'),
                'id' => 'sidebar-woocommerce',
                'description' => esc_attr__('Widgets in this area will be shown on Woocommerce Pages.', 'photty'),
                'before_widget' => '<div id="%1$s" class="widget woocommerce_widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h6 class="widgettitle"><span>',
                'after_title' => '</span></h6>',
            )
        );
    }
}

# Post Formats
function photty_get_post_formats($args = array())
{
    if (photty_post_options()) {
        $html = '';
        if (!empty($args)) {
            extract($args);
            if (isset($output_template) && $output_template == 'blog_grid') {
                $grid_ratio = $grid_img_height / $grid_img_width;
            }
        }


        $html .= '<div class="photty_post_formats photty_pf_' . get_post_format() . '">';
        if (get_post_format() == 'image') {
            if (is_array(photty_get_post_option('photty_pf_images'))) {
                # CSS
                wp_enqueue_style('owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css');
                # JS
                wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/js/owl.carousel.min.js', array('jquery'), false, true);

                $html .= '<div class="photty_owlCarousel owl-carousel owl-theme">';
                foreach (photty_get_post_option('photty_pf_images') as $key => $image) {
                    if (isset($output_template) && $output_template == 'blog_grid') {
                        $html .= '<div class="item"><img src="' . aq_resize($image['full_url'], $grid_img_width, $grid_img_height, true, true, true) . '" alt="' . $image['alt'] . '"></div>';
                    } else {
                        if (photty_get_post_option('photty_pf_images_crop_status', 'yes') == 'yes') {
                            $html .= '<div class="item"><img src="' . aq_resize($image['full_url'], photty_get_post_option('photty_pf_images_width', '1600'), photty_get_post_option('photty_pf_images_height', '900'), true, true, true) . '" alt="' . $image['alt'] . '"></div>';
                        } else {
                            $html .= '<div><img src="' . $image['full_url'] . '" alt="' . $image['alt'] . '"></div>';
                        }
                    }
                }
                $html .= '</div>';

                phottyHelper::getInstance()->addJSToFooter('owl_post_formats', '
                    jQuery(".photty_owlCarousel").on("initialized.owl.carousel", function(e) {
						jQuery(".photty_owlCarousel").css("opacity", "1");
					});
					jQuery(".photty_owlCarousel").owlCarousel(
                        {
                            items:1,
						    lazyLoad:true,
							loop:true,
							autoplay:false,
							autoplayTimeout:5000,
							autoplayHoverPause:true,
							autoHeight:true
                        }
                    );
                ');
            } else {
                if (isset($output_template) && $output_template == 'blog_grid') {
                    $html .= '<img class="photty_stand_fi" src="' . aq_resize(photty_get_featured_image_url(), $grid_img_width, $grid_img_height, true, true, true) . '" alt="'. get_the_title() .'">';
                } else {
                    $html .= '<img class="photty_stand_fi" src="' . aq_resize(photty_get_featured_image_url(), 300, 300) . '" alt="'. get_the_title() .'">';
                }
            }
        }

        if (get_post_format() == 'video') {
            if (isset($output_template) && $output_template == 'blog_grid') {
                $html .= '<div class="photty_pf_video_cont photty_blog_grid_ratio" data-ratio="' . esc_attr($grid_ratio) . '">' . photty_get_post_option('photty_pf_video_url') . '</div>';
            } else {
                $html .= '<div class="photty_pf_video_cont" style="height:' . photty_get_post_option('photty_pf_video_height', '500') . 'px;">' . photty_get_post_option('photty_pf_video_url') . '</div>';
            }
        }
        if (get_post_format() == 'audio') {
            if (isset($output_template) && $output_template == 'blog_grid') {
                $html .= '<div class="photty_pf_audio_cont photty_blog_grid_ratio" data-ratio="' . esc_attr($grid_ratio) . '">' . photty_get_post_option('photty_pf_audio_url') . '</div>';
            } else {
                $html .= '<div class="photty_pf_audio_cont">' . photty_get_post_option('photty_pf_audio_url') . '</div>';
            }
        }
        if (get_post_format() == 'quote') {
            if (isset($output_template) && $output_template == 'blog_grid') {
                $html .= '<div class="photty_pf_quote photty_blog_grid_ratio" data-ratio="' . esc_attr($grid_ratio) . '"><div class="photty_pf_quote_cont"><h5 class="photty_pf_quote_text">' . photty_get_post_option('photty_pf_quote_text') . '</h5><div class="photty_pf_quote_author">' . photty_get_post_option('photty_pf_quote_author') . '</div></div></div>';
            } else {
                $html .= '<div class="photty_pf_quote"><div class="photty_pf_quote_cont"><h5 class="photty_pf_quote_text">' . photty_get_post_option('photty_pf_quote_text') . '</h5><div class="photty_pf_quote_author">' . photty_get_post_option('photty_pf_quote_author') . '</div></div></div>';
            }
        }
        if (get_post_format() == '' && photty_get_featured_image_url()) {
			if (isset($output_template) && $output_template == 'blog_grid') {
            	$html .= '<a class="photty_blog_grid_img_link" href="'. get_permalink() .'"><img class="photty_stand_fi" src="' . aq_resize(photty_get_featured_image_url(), $grid_img_width, $grid_img_height, true, true, true) . '" alt="'. get_the_title() .'"></a>';
			} else {
				$html .= '<img class="photty_stand_fi" src="' . photty_get_featured_image_url() . '" alt="'. get_the_title() .'">';
			}
        }
		
        $html .= '</div>';
        return $html;
    } else {
        return '<div class="photty_post_formats"><img class="photty_stand_fi" src="' . photty_get_featured_image_url() . '" alt="'. get_the_title() .'"></div>';
    }
}

# RWMB check
function photty_post_options()
{
    if (class_exists('RWMB_Loader')) {
        return true;
    } else {
        return false;
    }
}

# RWMB get option
function photty_get_post_option($name, $default = false)
{
    if (class_exists('RWMB_Loader')) {
        if (rwmb_meta($name)) {
            return rwmb_meta($name);
        } else {
            return $default;
        }
    } else {
        return $default;
    }
}

# Get Preffered Option
function photty_get_prefered_option($name, $default)
{
    if (photty_get_post_option($name) && photty_get_post_option($name) !== 'default') {
        return photty_get_post_option($name);
    } else {
        return get_theme_mod($name, $default);
    }
}

# Previous and Next Posts
function photty_prev_next_posts()
{
    $prev_post = get_previous_post();
    $next_post = get_next_post();

    if (empty($prev_post) && empty($next_post)) {
        return;
    }

    global $post;

    echo '
        <div class="photty_prev_next_posts">
            <div class="row">
    ';

    echo '<div class="col-md-6 photty_prev_post">';

    if (!empty($prev_post)) {
        $post = get_post($prev_post->ID);
        setup_postdata($post);

        echo '
                    <div class="innerpadding">
                        <a class="photty_prev_post_link" href="' . get_comments_link() . '"></a>
                        <a class="notextdecor photty_post_title" href="' . get_permalink() . '">
                            <h5 class="innertitle">' . get_the_title() . '</h5>
                        </a>
                        <div class="photty_meta">
                            <div>' . get_the_date() . '</div>
                            <div>' . esc_attr__('by', 'photty') . ' ' . get_the_author_posts_link() . '</div>
                            <div>
                                <a href="' . get_comments_link() . '">' . esc_attr__('Comments', 'photty') . ': ' . get_comments_number() . '</a>
                            </div>
                        </div>
                    </div>
                ';

        wp_reset_postdata();
    }

    echo '</div>';
    echo '<div class="col-md-6 photty_next_post">';

    if (!empty($next_post)) {
        $post = get_post($next_post->ID);
        setup_postdata($post);

        echo '
                
                    <div class="innerpadding">
                        <a class="photty_next_post_link" href="' . get_comments_link() . '"></a>
                        <a class="notextdecor photty_post_title" href="' . get_permalink() . '">
                            <h5 class="innertitle">' . get_the_title() . '</h5>
                        </a>
                        <div class="photty_meta">
                            <div>' . get_the_date() . '</div>
                            <div>' . esc_attr__('by', 'photty') . ' ' . get_the_author_posts_link() . '</div>
                            <div>
                                <a href="' . get_comments_link() . '">' . esc_attr__('Comments', 'photty') . ': ' . get_comments_number() . '</a>
                            </div>
                        </div>
                    </div>
                ';

        wp_reset_postdata();
    }

    echo '
                </div>
            </div>
        </div>
    ';
}

# Get Featured Image Url
function photty_get_featured_image_url()
{
    $featured_image_full_url = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
    if (isset($featured_image_full_url[0]) && strlen($featured_image_full_url[0]) > 0) {
        return $featured_image_full_url[0];
    } else {
        return false;
    }
}

# Featured Posts
function photty_featured_posts($args = array('orderby' => 'rand', 'numberposts' => '2', 'featured_image' => 'show', 'excerpt' => 'show', 'post_meta' => 'show'))
{
    extract($args);

    if (photty_get_prefered_option('featured_posts_status', 'enabled') == 'enabled') {

        $args = array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'ignore_sticky_posts' => 1,
            'orderby' => esc_attr($orderby),
            'posts_per_page' => absint($numberposts),
        );

        query_posts($args);

        if (have_posts()) {

            echo '<h3 class="photty_tac">' . esc_attr__('You May Also Like', 'photty') . '</h3>';
            echo '<div class="row photty_featured_posts">';

            while (have_posts()) {
                the_post();
                ?>

                <div class="col-md-<?php echo(12 / $numberposts); ?>">
                    <?php if (photty_get_featured_image_url() && $featured_image == 'show') { ?>
                        <a href="<?php the_permalink(); ?>" class="photty_fimage photty_image_fader">
                            <img src="<?php echo aq_resize(photty_get_featured_image_url(), 800, 600, true, true, true); ?>" alt="<?php the_title(); ?>">
                        </a>
                    <?php } ?>
                    <a class="notextdecor photty_post_title" href="<?php the_permalink(); ?>">
                        <h5 class="innertitle"><?php the_title(); ?></h5>
                    </a>

                    <?php if ($post_meta == 'show') { ?>
                        <div class="photty_meta">
                            <div><?php echo get_the_date(); ?></div>
                            <div><?php echo esc_attr__('by', 'photty');
                                echo ' ';
                                the_author_posts_link(); ?></div>
                            <div><?php echo esc_attr__('in', 'photty');
                                echo ' ';
                                the_category(', '); ?></div>
                        </div>
                    <?php } ?>

                    <?php if ($excerpt == 'show') { ?>
                        <div class="photty_excerpt">
                            <?php the_excerpt(); ?>
                        </div>
                    <?php } ?>
                </div>
                <?php
            }
            wp_reset_query();

            echo '</div>';
        }
    }
}

# Featured Albums
function photty_featured_albums($args = array('orderby' => 'rand', 'numberposts' => '2', 'featured_image' => 'show'))
{
    extract($args);

    if (photty_get_prefered_option('featured_posts_status', 'enabled') == 'enabled') {

        $args = array(
            'post_type' => 'albums',
            'post_status' => 'publish',
            'orderby' => esc_attr($orderby),
            'posts_per_page' => absint($numberposts),
        );

        query_posts($args);

        if (have_posts()) {

            echo '<h3 class="photty_tac photty_tac_albums">' . esc_attr__('You May Also Like', 'photty') . '</h3>';
            echo '<div class="row photty_featured_albums">';

            while (have_posts()) {
                the_post();
                ?>

                <div class="photty_featured_albums_col col-md-<?php echo(12 / $numberposts); ?>">
                	<div class="photty_featured_albums_item">
						<?php if (photty_get_featured_image_url() && $featured_image == 'show') { ?>
                            <a href="<?php the_permalink(); ?>" class="photty_featured_albums_image photty_image_fader">
                                <img src="<?php echo aq_resize(photty_get_featured_image_url(), 915, 600, true, true, true); ?>" alt="<?php the_title(); ?>">
                            </a>
                        <?php } 
							$galCateg = '';
							$new_term_list = get_the_terms(get_the_id(), "albumscat");
							if (is_array($new_term_list)) {
								foreach ($new_term_list as $term) {
									$galCateg .= $term->name . " / ";
								}
							} else {
								$galCateg = 'Uncategorized  ';
							}
							$galCateg = substr($galCateg, 0, -2);						
						?>
                        <div class="photty_features_albums_content">
                            <a class="photty_features_albums_title" href="<?php the_permalink(); ?>">
                                <h5 class="innertitle"><?php the_title(); ?></h5>
                            </a>
                            <div class="photty_featured_albums_meta">
                            	<?php echo photty_output($galCateg); ?>
                            </div>
                        </div>    
                    </div>
                </div>
                <?php
            }
            wp_reset_query();

            echo '</div>';
        }
    }
}

# Transparent Header Check
function photty_transparent_header_check()
{
    if (!is_404()) {
        if (photty_get_prefered_option('header_transparent', 'disabled') == 'enabled') {
            phottyHelper::getInstance()->addJSToFooter('transp_head', '
        jQuery("html").addClass("photty_transparent_header");
    ');
        } else {
            phottyHelper::getInstance()->addJSToFooter('non_transp_head', '
        jQuery("html").addClass("photty_non_transparent_header");
    ');
        }
    }
}

# VC Init
add_action('vc_before_init', 'photty_vc_before_init_actions');
function photty_vc_before_init_actions()
{
    setcookie('vchideactivationmsg', '1', strtotime('+3 years'), '/');
    setcookie('vchideactivationmsg_vc11', (defined('WPB_VC_VERSION') ? WPB_VC_VERSION : '1'), strtotime('+3 years'), '/');
    vc_set_as_theme();

    require_once(get_template_directory() . '/core/vc-elements/blog/blog.php');
    require_once(get_template_directory() . '/core/vc-elements/blog_grid/blog_grid.php');
    require_once(get_template_directory() . '/core/vc-elements/countdown/countdown.php');
    require_once(get_template_directory() . '/core/vc-elements/grid_gallery/grid_gallery.php');
    require_once(get_template_directory() . '/core/vc-elements/image_carousel/image_carousel.php');
    require_once(get_template_directory() . '/core/vc-elements/price_table/price_table.php');
    require_once(get_template_directory() . '/core/vc-elements/testimonials/testimonials.php');
    require_once(get_template_directory() . '/core/vc-elements/works_slider/works_slider.php');
    require_once(get_template_directory() . '/core/vc-elements/promo_text/promo_text.php');
    require_once(get_template_directory() . '/core/vc-elements/stripes/stripes.php');
    require_once(get_template_directory() . '/core/vc-elements/simple_slider/simple_slider.php');
}

# PRE
function photty_pre($array)
{
    echo '<pre>';
    print_r($array);
    echo '</pre>';
}

# Get Image Meta
function photty_get_attachment($attachment_id)
{
    $attachment = get_post($attachment_id);
    return array(
        'alt' => get_post_meta($attachment->ID, '_wp_attachment_image_alt', true),
        'caption' => $attachment->post_excerpt,
        'description' => $attachment->post_content,
        'href' => get_permalink($attachment->ID),
        'src' => $attachment->guid,
        'title' => $attachment->post_title
    );
}

add_filter('admin_footer', 'photty_admin_footer');
function photty_admin_footer()
{
    echo "<input type='hidden' name='' value='" . (get_page_template_slug() ? get_page_template_slug() : '') . "' class='photty_this_template_file'>";
}

# WP_Head
add_action('wp_head', 'photty_wp_head');
function photty_wp_head()
{
    echo "
    <script type='text/javascript'>
    var photty_ajaxurl = '" . admin_url('admin-ajax.php') . "';
    </script>";

    echo (strlen(get_theme_mod('photty_code_before_head_val', '')) > 0 ? get_theme_mod('photty_code_before_head_val', '') : '');
}

# Admin_Head
add_action('admin_head', 'photty_admin_head');
function photty_admin_head()
{
    echo "
    <script type='text/javascript'>
    var photty_themeurl = '" . esc_url(get_template_directory_uri()) . "';
    </script>";
}

# Tiny Dropcap Button
add_editor_style('css/core/pm_tiny.css');
add_action('init', 'photty_tiny');
function photty_tiny()
{
    if (current_user_can('edit_posts') && current_user_can('edit_pages')) {
        add_filter('mce_external_plugins', 'photty_tiny_plugin');
        add_filter('mce_buttons', 'photty_tiny_register_button');
    }
}

function photty_tiny_plugin($plugin_array)
{
    $plugin_array['photty_tiny'] = esc_url(get_template_directory_uri()) . '/js/core/pm_tiny.js';
    return $plugin_array;
}

function photty_tiny_register_button($buttons)
{
    array_push($buttons, "photty_dropcap");
    return $buttons;
}

add_filter('mce_buttons_2', 'photty_mce_buttons_2');
function photty_mce_buttons_2($buttons)
{
    array_push($buttons, 'backcolor');
    return $buttons;
}

add_filter('preview_post_link', 'photty_remove_post_format_parameter', 9999);
function photty_remove_post_format_parameter($url) {
    $url = remove_query_arg('post_format', $url);
    return $url;
}

add_filter('wp_list_categories', 'photty_category_filter');
function photty_category_filter($links) {
  $links = str_replace('</a> (', ' (', $links);
  $links = str_replace(')', ')</a>', $links);
  return $links;
}

/* Social Icons */
if (!function_exists('photty_show_social_icons')) {
	function photty_show_social_icons($array)
	{
		$compile = "";
		$compile .= '
			<div class="photty_social_icons"><ul class="photty_social_icons_list">';
		
		foreach ($array as $key => $value) {
			if (strlen(get_theme_mod($value['uniqid'], '')) > 0) {
				$compile .= "<li class='photty_social_icons_item'><a class='" . $value['class'] . "' target='" . $value['target'] . "' href='" . get_theme_mod($value['uniqid'], '') . "' title='" . $value['title'] . "'><i class='fa fa-" . $value['class'] . "'></i></a></li>";
			}
		}
		$compile .= "</ul></div>";
		if (is_array($array) && count($array) > 0) {
			return $compile;
		} else {
			return "";
		}
	}
}
# Activate Visual Composer for Custom Post Types
$list = array(
    'page',
	'post',
	'albums'
);
if (function_exists('vc_set_default_editor_post_types')) {
	vc_set_default_editor_post_types($list);
}

#Add custom post type to settings reading drop down & fix redirect rules for home page at this state
add_filter('get_pages', 'photty_cpt_to_dd_homepage');
function photty_cpt_to_dd_homepage($pages) {
    $photty_cpt_pages = new WP_Query(array('post_type' => 'albums', 'posts_per_page' => -1));
    if ($photty_cpt_pages->post_count > 0) {
        $pages = array_merge($pages, $photty_cpt_pages->posts);
    }
    return $pages;
}

function photty_enable_front_page_cpt($query) {
    if (empty($query->query_vars['post_type']) && $query->query_vars['page_id'] != 0 && $query->query_vars['preview'] !== "true") {
        $query->query_vars['post_type'] = array('page', 'albums');
    }
}
add_action('pre_get_posts', 'photty_enable_front_page_cpt');
#END Add custom post type to settings reading drop down & fix redirect rules for home page at this state

function photty_add_template_slug_to_body( $classes ) {
	$templateName = basename(get_page_template_slug(get_the_ID()));
	$templateName = str_ireplace('template-', '', basename(get_page_template_slug(get_the_ID()), '.php'));

	$pf = get_post_format(get_the_ID());
	$post_type = get_post_format(get_the_ID());
	$post_type_class = '';
	
	if (!empty($post_type)) {
		$post_type_class = ' post-type-' . get_post_format();
	}
	
    return $classes . $templateName . $post_type_class;
}
add_filter('admin_body_class', 'photty_add_template_slug_to_body');

if (!function_exists( 'photty_is_woocommerce_activated')) {
	function photty_is_woocommerce_activated() {
		return class_exists( 'WooCommerce' ) ? true : false;
	}
}

if (photty_is_woocommerce_activated()) {
    add_action('customize_register', 'photty_shop_customizer_register');
    function photty_shop_customizer_register($wp_customize) {        
        
        $wp_customize->add_section('photty_shop_settings',
            array(
                'title' => esc_attr__('Photty Shop Settings', 'photty'),
                'panel' => 'woocommerce',
            )
        );
        $wp_customize->add_section('photty_shop_colors',
            array(
                'title' => esc_attr__('Additional Shop Colors', 'photty'),
                'panel' => 'woocommerce',
            )
        );

        # Sidebar Position
        $wp_setting_name = 'shop_sidebar_position';
        $wp_customize->add_setting($wp_setting_name, array('default' => 'photty_right_sidebar', 'sanitize_callback'	=> 'esc_attr'));
        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label' => esc_attr__('Sidebar Position', 'photty'),
                'section' => 'photty_shop_settings',
                'settings' => $wp_setting_name,
                'type' => 'select',
                'choices' => array('photty_left_sidebar' => 'Left', 'photty_right_sidebar' => 'Right', 'photty_no_sidebar' => 'None'),
            )
        ));
        
        # Sale Label
        $wp_setting_name = 'shop_sale_label';
        $wp_customize->add_setting($wp_setting_name, array('default' => 'on', 'sanitize_callback'	=> 'esc_attr'));
        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label' => esc_attr__('Sale Label State', 'photty'),
                'section' => 'photty_shop_settings',
                'settings' => $wp_setting_name,
                'type' => 'select',
                'choices' => array('on' => 'On', 'off' => 'Off'),
            )
        ));
        
        # Product Lightbox
        $wp_setting_name = 'shop_lightbox';
        $wp_customize->add_setting($wp_setting_name, array('default' => 'on', 'sanitize_callback'	=> 'esc_attr'));
        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label' => esc_attr__('Single Product Image Lightbox', 'photty'),
                'section' => 'photty_shop_settings',
                'settings' => $wp_setting_name,
                'type' => 'select',
                'choices' => array('on' => 'On', 'off' => 'Off'),
            )
        ));
        
        # Product Zoom
        $wp_setting_name = 'shop_zoom';
        $wp_customize->add_setting($wp_setting_name, array('default' => 'on', 'sanitize_callback'	=> 'esc_attr'));
        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label' => esc_attr__('Single Product Image Zoom', 'photty'),
                'section' => 'photty_shop_settings',
                'settings' => $wp_setting_name,
                'type' => 'select',
                'choices' => array('on' => 'On', 'off' => 'Off'),
            )
        ));
        
        # Product Slider
        $wp_setting_name = 'shop_slider';
        $wp_customize->add_setting($wp_setting_name, array('default' => 'on', 'sanitize_callback'	=> 'esc_attr'));
        $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            $wp_setting_name,
            array(
                'label' => esc_attr__('Single Product Image Slider', 'photty'),
                'section' => 'photty_shop_settings',
                'settings' => $wp_setting_name,
                'type' => 'select',
                'choices' => array('on' => 'On', 'off' => 'Off'),
            )
        ));
    }
}

if (class_exists('WooCommerce')) {
    add_theme_support( 'woocommerce', array(
        'thumbnail_image_width' => 500,
        'thumbnail_image_height' => 500,
        'single_image_width'    => 640,
        'product_grid'          => array(
            'default_rows'    => 3,
            'min_rows'        => 2,
            'max_rows'        => 8,
            'default_columns' => 3,
            'min_columns'     => 2,
            'max_columns'     => 5,
        ),
    ));
    if (get_theme_mod('shop_zoom', 'on') == 'on') {
        add_theme_support( 'wc-product-gallery-zoom' );
    }
    if (get_theme_mod('shop_lightbox', 'on') == 'on') {
        add_theme_support( 'wc-product-gallery-lightbox' );
    }
    if (get_theme_mod('shop_slider', 'on') == 'on') {
        add_theme_support( 'wc-product-gallery-slider' );
    }
}

if (function_exists('photty_add_widget')) 
{
	add_action('widgets_init', 'photty_widgets_activate');
	if (!function_exists('photty_widgets_activate')) 
	{
		function photty_widgets_activate() {
			photty_add_widget('phottyGalleryPosts');
			photty_add_widget('phottyFeaturedPosts');
			photty_add_widget('phottyTextTable');
		}
	}
}

if (!function_exists('photty_output')) {
    function photty_output($code) {
        return $code;
    }
}

function update_woocommerce_version() {
  if(class_exists('WooCommerce')) {
    global $woocommerce;

    if(version_compare(get_option('woocommerce_db_version', null), $woocommerce->version, '!=')) {
      update_option('woocommerce_db_version', $woocommerce->version);

      if(! wc_update_product_lookup_tables_is_running()) {
        wc_update_product_lookup_tables();
      }
    }
  }
}
add_action('init', 'update_woocommerce_version');
