<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

add_action('wp_head', 'photty_custom_css');
function photty_custom_css()
{
    echo '
    <style type="text/css">
	body {
		background-color: ' . get_theme_mod('body_bg_color', '#ffffff') . ';
	}
	body.boxed {
		background-color: ' . get_theme_mod('boxed_bg_color', '#edeef0') . ';
	}
	body.boxed > .container {
		background-color: ' . get_theme_mod('body_bg_color', '#ffffff') . ';
	}
    .photty_dropcaps,
    a,
    a .innertitle:hover,
    .photty_meta a:hover,
    .page-numbers.current,
	.photty_content .photty_contact_info a:hover {
        color: ' . get_theme_mod('color_main', '#e44b3c') . ';
    }
    .form-submit input,
	.post-password-form input[type="submit"],
    .photty_404_home_btn,
    .wpcf7-submit,
    .photty_button,
    .page-numbers:hover {
        background-color: ' . get_theme_mod('color_main', '#e44b3c') . ';
    }
    
    body .wp-block-button a.wp-block-button__link:hover {
        background: ' . get_theme_mod('color_main', '#e44b3c') . ';
        border-color: ' . get_theme_mod('color_main', '#e44b3c') . ';
    }
    .wp-block-button.is-style-outline a.wp-block-button__link:hover {
        border-color: ' . get_theme_mod('color_main', '#e44b3c') . ';
    }

    h1, h2, h3, h4, h5, h6 {
        color: ' . get_theme_mod('color_headings', '#2b2d38') . ';
    }
    body,
	.photty_grid_post_wrapper {
        font-family: "' . get_theme_mod('main_font_family', 'Roboto') . '";
        font-size: ' . absint(get_theme_mod('main_font_size', '14')) . 'px;
        line-height: ' . absint(get_theme_mod('main_line_height', '22')) . 'px;
        font-weight: ' . absint(get_theme_mod('main_font_weight', '400')) . ';
        color: ' . get_theme_mod('color_content', '#737479') . ';
    }
	.photty_albums_categories a,
	.photty_albums_listing_wrapper nav.navigation.pagination a {
		color: ' . get_theme_mod('color_content', '#737479') . ';
	}
	.photty_albums_categories a:hover {
		color: ' . get_theme_mod('color_main', '#e44b3c') . ';
	}
    header {
        background-color: rgba(' . photty_hex2rgb(get_theme_mod('header_bg_color', '#1f232f')) . ', ' . (absint(get_theme_mod('sticky_header_opacity', '100')) / 100) . ');
    }
    header .photty_logo_cont {
        padding-top: ' . absint(get_theme_mod('logo_padding_top', '22')) . 'px;
        padding-bottom: ' . absint(get_theme_mod('logo_padding_bottom', '22')) . 'px;
    }
    ';

    # Image Logo
    if (get_theme_mod('logo_type', 'image_logo') == 'image_logo') {
        $photty_logo_metadata = wp_get_attachment_metadata(attachment_url_to_postid(get_theme_mod('logo_image', get_template_directory_uri() . '/img/logo.png')));
        $photty_logo_width = (isset($photty_logo_metadata['width']) ? $photty_logo_metadata['width'] : '336');
        $photty_logo_height = (isset($photty_logo_metadata['height']) ? $photty_logo_metadata['height'] : '72');

        echo '
        header .photty_image_logo {
            width: ' . absint($photty_logo_width) . 'px;
            height: ' . absint($photty_logo_height) . 'px;
            background: url("' . esc_url(get_theme_mod('logo_image', get_template_directory_uri() . '/img/logo.png')) . '") 0 0 no-repeat transparent;
        }
        ';

        # Retina
        if (get_theme_mod('logo_retina', true) == true) {
            $photty_logo_width = $photty_logo_width / 2;
            $photty_logo_height = $photty_logo_height / 2;
            echo '
            header .photty_image_logo.photty_retina {
                width: ' . absint($photty_logo_width) . 'px;
                height: ' . absint($photty_logo_height) . 'px;
                background-size: ' . absint($photty_logo_width) . 'px ' . absint($photty_logo_height) . 'px;
            }
            ';
        }
        $photty_menu_lh_fix = 3;
    }

    # Text Logo
    if (get_theme_mod('logo_type', 'image_logo') == 'text_logo') {
        $photty_logo_height = absint(get_theme_mod('logo_text_size', '24'));
        $photty_menu_lh_fix = 6;
        echo '
        header .photty_text_logo a {
            font-size: ' . absint(get_theme_mod('logo_text_size', '24')) . 'px;
            line-height: ' . absint(get_theme_mod('logo_text_size', '24')) . 'px;
            color: ' . get_theme_mod('logo_text_color', '#ffffff') . ';
            font-weight: ' . get_theme_mod('logo_text_weight', '700') . ';
            font-style: ' . (get_theme_mod('logo_text_style_italic', false) == true ? 'italic' : 'normal') . ';
            font-family:"' . get_theme_mod('logo_text_font', 'Roboto') . '";
            text-transform:' . (get_theme_mod('logo_text_style_uppercase', true) == true ? 'uppercase' : 'none') . ';
        }
        .photty_transparent_header header .photty_text_logo a {
            color: ' . get_theme_mod('logo_text_color_transparent_header', '#ffffff') . ';
        }
        header .photty_text_logo a:hover {
            color: ' . get_theme_mod('logo_text_hover', '#e44b3c') . ';
        }
        .photty_transparent_header header .photty_text_logo a:hover {
            color: ' . get_theme_mod('logo_text_hover_transparent_header', '#e44b3c') . ';
        }
        ';
    }

    # Footer Image Logo
    if (get_theme_mod('footer_logo_type', 'image_logo') == 'image_logo') {
        $photty_footer_logo_metadata = wp_get_attachment_metadata(attachment_url_to_postid(get_theme_mod('footer_logo_image', get_template_directory_uri() . '/img/logo.png')));
        $photty_footer_logo_width = (isset($photty_footer_logo_metadata['width']) ? $photty_footer_logo_metadata['width'] : '336');
        $photty_footer_logo_height = (isset($photty_footer_logo_metadata['height']) ? $photty_footer_logo_metadata['height'] : '72');

        echo '
        footer .photty_image_logo {
            width: ' . absint($photty_footer_logo_width) . 'px;
            height: ' . absint($photty_footer_logo_height) . 'px;
            background: url("' . esc_url(get_theme_mod('footer_logo_image', get_template_directory_uri() . '/img/logo.png')) . '") 0 0 no-repeat transparent;
        }
        ';

        # Footer Logo Retina
        if (get_theme_mod('footer_logo_retina', true) == true) {
            $photty_footer_logo_width = $photty_footer_logo_width / 2;
            $photty_footer_logo_height = $photty_footer_logo_height / 2;
            echo '
            footer .photty_image_logo.photty_retina {
                width: ' . absint($photty_footer_logo_width) . 'px;
                height: ' . absint($photty_footer_logo_height) . 'px;
                background-size: ' . absint($photty_footer_logo_width) . 'px ' . absint($photty_footer_logo_height) . 'px;
            }
            ';
        }
    }

    # Footer Text Logo
    if (get_theme_mod('footer_logo_type', 'image_logo') == 'text_logo') {
        $photty_footer_logo_height = absint(get_theme_mod('footer_logo_text_size', '24'));
        echo '
        footer .photty_text_logo a {
            font-size: ' . absint(get_theme_mod('footer_logo_text_size', '24')) . 'px;
            line-height: ' . absint(get_theme_mod('footer_logo_text_size', '24')) . 'px;
            color: ' . get_theme_mod('footer_logo_text_color', '#ffffff') . ';
            font-weight: ' . get_theme_mod('footer_logo_text_weight', '700') . ';
            font-style: ' . (get_theme_mod('footer_logo_text_style_italic', false) == true ? 'italic' : 'normal') . ';
            font-family:"' . get_theme_mod('footer_logo_text_font', 'Roboto') . '";
            text-transform:' . (get_theme_mod('footer_logo_text_style_uppercase', true) == true ? 'uppercase' : 'none') . ';
        }
        footer .photty_text_logo a:hover {
            color: ' . get_theme_mod('footer_logo_text_hover', '#e44b3c') . ';
        }
        ';
    }

    # Header Menu & Logo
    echo '
    header .photty_menu li a {
        color: ' . get_theme_mod('header_links_color', '#ffffff') . ';
        font-family:"' . get_theme_mod('header_menu_font_family', 'Roboto') . '";
        text-transform: ' . (get_theme_mod('header_menu_uppercase', true) == true ? 'uppercase' : 'none') . ';
        font-style: ' . (get_theme_mod('header_menu_italic', false) == true ? 'italic' : 'normal') . ';
        font-weight: ' . get_theme_mod('header_menu_font_weight', '400') . ';
        font-size: ' . absint(get_theme_mod('header_menu_font_size', '14')) . 'px;
        line-height: ' . absint(get_theme_mod('header_menu_font_size', '14')) . 'px;
    }
    .photty_transparent_header header .photty_menu > li > a {
        color: ' . get_theme_mod('header_links_color_transparent_header', '#ffffff') . ';
    }
    .photty_transparent_header header .photty_menu > li > a:after {
        background-color: ' . get_theme_mod('header_links_color_transparent_header', '#ffffff') . ';
    }
    header .photty_menu > li > a {
        line-height: ' . (absint(get_theme_mod('logo_padding_top', '22')) + absint(get_theme_mod('logo_padding_bottom', '22')) + $photty_logo_height - $photty_menu_lh_fix) . 'px;
        padding-top: ' . absint($photty_menu_lh_fix) . 'px;
    }
    header .photty_menu li .sub-menu li a {
        background-color: ' . get_theme_mod('header_bg_color', '#1f232f') . ';
    }
    header .photty_menu li .sub-menu li a {
        font-size: ' . (absint(get_theme_mod('header_menu_font_size', '14')) + 1) . 'px;
        line-height: ' . (absint(get_theme_mod('header_menu_font_size', '14')) + 1) . 'px;
    }
    header .photty_menu .sub-menu li.menu-item-has-children:after {
        color: ' . get_theme_mod('header_links_color', '#ffffff') . ';
    }
	ul.mobile_menu li a {
		color: ' . get_theme_mod('header_links_color', '#ffffff') . ';
	}
    header .photty_menu li:hover li:hover > a, header .sub-menu li.current-menu-item > a,
    header .photty_menu .sub-menu li.menu-item-has-children:hover:after {
        color: ' . get_theme_mod('header_links_hover_color', '#e44b3c') . ';
    }
	ul.mobile_menu li a:hover,
	ul.mobile_menu li.current-menu-ancestor > a,
	ul.mobile_menu li.current-menu-item > a {
		color: ' . get_theme_mod('header_links_color', '#e44b3c') . ';
	}
    header.logo_center .photty_menu > li > a {
        line-height: ' . absint(get_theme_mod('header_menu_font_size', '14')) . 'px;
        padding-bottom: ' . absint(get_theme_mod('logo_padding_bottom', '22')) . 'px;
    }
    header .photty_menu li .sub-menu a:after {
        background-color: ' . get_theme_mod('header_sub_menu_spacer_color', '#363944') . ';
    }
    header.logo_center .photty_menu > li > a:after {
        margin-top: ' . (absint(get_theme_mod('header_menu_font_size', '14')) + 5) . 'px;
    }
	.post-password-form  p {
		color: ' . get_theme_mod('protected_text_color', '#ffffff') . ';
	}
	.post-password-form input[type="password"] {
		border-color: ' . get_theme_mod('protected_text_color', '#ffffff') . ';
		color: ' . get_theme_mod('protected_text_color', '#ffffff') . ';
	}
	.post-password-form input[type="password"]::-webkit-input-placeholder {
		color: ' . get_theme_mod('protected_text_color', '#ffffff') . ';
	}
	.post-password-form input[type="password"]::-moz-placeholder {
		color: ' . get_theme_mod('protected_text_color', '#ffffff') . ';
	}

    .error404 h1, .error404 h2, .error404 h3, .error404 h4, .error404 h5, .error404 h6, .error404 p, .error404 header .photty_menu > li > a, .error404 header .photty_text_logo a,
    .photty_404_home_btn {
        color: ' . get_theme_mod('404_text_color', '#ffffff') . ';
    }
    .error404 header .photty_menu > li > a::after {
        background-color: ' . get_theme_mod('404_text_color', '#ffffff') . ';
    }
    .page-template-page-coming-soon h1, .page-template-page-coming-soon h2, .page-template-page-coming-soon h3, .page-template-page-coming-soon h4, .page-template-page-coming-soon h5, .page-template-page-coming-soon h6, .page-template-page-coming-soon p, .page-template-page-coming-soon div, .page-template-page-coming-soon header .photty_text_logo a {
        color: ' . get_theme_mod('cs_text_color', '#ffffff') . ';
    }
    ul.wp-block-latest-posts li a,
    ul.wp-block-archives-list li a,
    ul.wp-block-categories-list li a {
        color: ' . get_theme_mod('color_content', '#737479') . ';
    }
    ul.wp-block-latest-posts li a:hover,
    ul.wp-block-archives-list li a:hover,
    ul.wp-block-categories-list li a:hover {
        color: ' . get_theme_mod('color_main', '#e44b3c') . ';
    }

    ';

    # Footer
    echo '
    footer {
        background-color: ' . get_theme_mod('footer_bg_color', '#1f232f') . ';
        color: ' . get_theme_mod('footer_text_color', '#737479') . ';
    }
    footer a {
        color: ' . get_theme_mod('footer_links_color', '#ffffff') . ';
    }
    footer a:hover {
        color: ' . get_theme_mod('footer_links_hover_color', '#e44b3c') . ';
    }
    footer .widgettitle {
        color: ' . get_theme_mod('footer_headings_color', '#ffffff') . ';
    }
    .footer_spacer {
        background-color: ' . get_theme_mod('footer_border_color', '#363944') . ';
    }
    footer .widget_phottytexttable .photty_tt_row,
    body footer .widget_phottyfeaturedposts .photty_posts_item {
        border-color: ' . get_theme_mod('footer_border_color', '#363944') . ';
    }
	.photty_sidebar .widget a {
		color: ' . get_theme_mod('color_content', '#737479') . ';
	}
	.photty_sidebar .widget_phottyfeaturedposts a:hover {
		color: ' . get_theme_mod('color_main', '#e44b3c') . ';
	}
    footer .photty_logo_cont {
        padding-top: ' . absint(get_theme_mod('footer_logo_padding_top', '22')) . 'px;
        padding-bottom: ' . absint(get_theme_mod('footer_logo_padding_bottom', '22')) . 'px;
    }
    footer .photty_copy_text {
        line-height: ' . ((absint(get_theme_mod('footer_logo_padding_top', '22')) + absint(get_theme_mod('footer_logo_padding_bottom', '22')) + $photty_footer_logo_height) - 1) . 'px;
    }
    footer .photty_copy_text {
        color: ' . get_theme_mod('footer_copyright_color', '#ffffff') . ';
    }
    footer.logo_center .photty_copy_text {
        padding-bottom: ' . absint(get_theme_mod('footer_logo_padding_bottom', '22')) . 'px;
        line-height: ' . absint(get_theme_mod('footer_small_text_lh', '13')) . 'px;
    }
    footer .widgets_area {
        padding-top: ' . absint(get_theme_mod('footer_widgets_padding_top', '60')) . 'px;
        padding-bottom: ' . absint(get_theme_mod('footer_widgets_padding_bottom', '0')) . 'px;
    }
	footer .widget_calendar caption,
	footer .widget_calendar th {
		color: ' . get_theme_mod('footer_headings_color', '#ffffff') . ';
	}	
    ';

    # Other
    echo '
	.photty_sidebar .widget a:hover {
		color: ' . get_theme_mod('color_main', '#e44b3c') . ';			
	}
	.widget_calendar caption,
	.widget_calendar th {
		color: ' . get_theme_mod('color_headings', '#2b2d38') . ';
	}
	.photty_sidebar .tagcloud a {
		background-color: ' . get_theme_mod('body_bg_color', '#ffffff') . ';
		color: ' . get_theme_mod('color_content', '#737479') . ';
	}
	.photty_sidebar .tagcloud a:hover {
		background-color: ' . get_theme_mod('color_main', '#e44b3c') . ';
		color: ' . get_theme_mod('body_bg_color', '#ffffff') . ';
		border-color: ' . get_theme_mod('color_main', '#e44b3c') . ';
	}	
	footer .tagcloud a:hover {
		border-color: ' . get_theme_mod('footer_text_color', '#737479') . ';
	}
	footer .widget_search input,
	footer .widget select,
	footer .widget_calendar table,
	footer .widget_calendar td,
	footer .widget_calendar th,
	footer .widget_product_categories ul li,
	footer .widget_nav_menu ul li,
	footer .widget_archive ul li,
	footer .widget_pages ul li,
	footer .widget_categories ul li,
	footer .widget_recent_entries ul li,
	footer .widget_meta ul li,
	footer .widget_recent_comments ul li,	
	footer .widget_pages ul li a,
	footer .widget_nav_menu ul li a {
		border-color:' . get_theme_mod('footer_border_color', '#363944') . ';	
	}
	
	
	
    blockquote,
    .form-submit input,
    .wpcf7-submit,
    .page-numbers:hover {
        border-color: ' . get_theme_mod('color_main', '#e44b3c') . ';
    }
    .photty_meta a {
        color: ' . get_theme_mod('color_content', '#737479') . ';
    }
    .owl-theme .owl-controls .owl-page span {
        background-color: ' . get_theme_mod('color_content', '#737479') . ';
    }
	
	input[type="tel"]::-webkit-input-placeholder,
	input[type="search"]::-webkit-input-placeholder,
	input[type="text"]::-webkit-input-placeholder,
	input[type="number"]::-webkit-input-placeholder,
	input[type="email"]::-webkit-input-placeholder,
	input[type="password"]::-webkit-input-placeholder,
	textarea::-webkit-input-placeholder {
		color:' . get_theme_mod('color_content', '#737479') . ';
	}
	input[type="search"]::-moz-placeholder {
		color:' . get_theme_mod('color_content', '#737479') . ';
	}
	input[type="text"]::-moz-placeholder {
		color:' . get_theme_mod('color_content', '#737479') . ';
	}
	input[type="number"]::-moz-placeholder {
		color:' . get_theme_mod('color_content', '#737479') . ';
	}
	input[type="tel"]::-moz-placeholder {
		color:' . get_theme_mod('color_content', '#737479') . ';
	}
	input[type="email"]::-moz-placeholder {
		color:' . get_theme_mod('color_content', '#737479') . ';
	}
	input[type="password"]::-moz-placeholder {
		color:' . get_theme_mod('color_content', '#737479') . ';
	}
	textarea::-moz-placeholder {
		color:' . get_theme_mod('color_content', '#737479') . ';
	}	
	.pm_contact_form span.wpcf7-not-valid-tip {
		color: ' . get_theme_mod('color_main', '#e44b3c') . ';
	}
	
	/* Price Table Module */
	.photty_price_item_price_block span,
	.photty_price_item_content p,
	.photty_price_item_content {
		color: ' . get_theme_mod('color_headings', '#2b2d38') . ';
	} 
    .photty_price_table_item.most_popular_item .photty_button,
	.photty_price_table_item .photty_button:hover {
        background-color: ' . get_theme_mod('color_main', '#e44b3c') . ';
    }
	
	/* Albums Slider */
	.photty_albums_slider body {
		background-color: rgba(' . photty_hex2rgb(get_theme_mod('header_bg_color', '#1f232f')) . ', ' . (absint(get_theme_mod('sticky_header_opacity', '100')) / 100) . ');
	}
	
	/* Preloader */
	.photty_preloader_wrapper {
		background-color: ' . get_theme_mod('body_bg_color', '#ffffff') . ';
	}
	.photty_preloader_wrapper .photty_preloader_bar .photty_preloader_line {
		background-color: ' . get_theme_mod('color_main', '#e44b3c') . ';
	}

	/* Back to Top */
	.photty_back_to_top {
		background:rgba(' . photty_hex2rgb(get_theme_mod('color_main', '#e44b3c')) . ', 0.9)
	}
	
	/* Header Socials */
	.photty_social_icons_list li a,
	.photty_social_icons_list li a:hover {
		color:' . get_theme_mod('header_links_color', '#ffffff') . ';
	}
	.photty_transparent_header .photty_social_icons_list li a,
	.photty_transparent_header .photty_social_icons_list li a:hover {
		color:' . get_theme_mod('header_links_color_transparent_header', '#ffffff') . ';
	}
    ';
	if (get_theme_mod('default_overlay_state', 'show') == 'hide') {
		echo '
			.photty_even_slide:before,
			.photty_odd_slide:before,
			.photty_fullscreen_slider:before,
			.photty_ribbon_slider:before,
			.photty_single_album_head:before,
			.photty_albums_slide:before {
				display:none;
			}

		';
	}

	# WooCommerce
	if (class_exists('WooCommerce')) {
		echo '
			body a.reset_variations,
			body button.button,
			body button.button.alt,
			body .photty_container .checkout-button.button,
			body .woocommerce .cart .button, 
			body .woocommerce .cart input.button,
			body.woocommerce ul.products li.product a.added_to_cart.wc-forward,
			body .photty_container #respond input#submit, 
			body .photty_container a.button, 
			body .photty_container button.button, 
			body .photty_container input.button
			body .photty_container .button,
			.woocommerce a.woocommerce-MyAccount-downloads-file.button,
			.woocommerce p.order-again a.button,
			body .photty_container .widget_price_filter .price_slider_amount .button {
                background-color: ' . get_theme_mod('color_main', '#e44b3c') . ';
			}
            html .woocommerce div.product form.cart .button:hover,
			html .woocommerce a.woocommerce-MyAccount-downloads-file.button.alt:hover,
			html .woocommerce #respond input#submit.alt:hover, 
			html .woocommerce a.button.alt:hover, 
			html .woocommerce button.button.alt:hover, 
			html .woocommerce input.button.alt:hover,
			html body button.button.alt:hover {
                background-color: ' . get_theme_mod('color_main', '#e44b3c') . ';
			}
            
            body.woocommerce .photty_container nav.woocommerce-pagination ul.page-numbers li span {
                color: ' . get_theme_mod('color_main', '#e44b3c') . ';
            }
            body.woocommerce .photty_container nav.woocommerce-pagination ul.page-numbers li a:hover {
				background-color: rgba(' . photty_hex2rgb(get_theme_mod('color_main', '#e44b3c')) . ', 1);
                color: ' . get_theme_mod('body_bg_color', '#ffffff') . ';
                border-color: rgba(' . photty_hex2rgb(get_theme_mod('color_main', '#e44b3c')) . ', 1);
            }
            
			body .photty_container ul.cart_list li a, 
			body .photty_container ul.product_list_widget li a {

			}
			body .photty_container ul.cart_list li a:hover, 
			body .photty_container ul.product_list_widget li a:hover {

			}
			body .photty_container ul.cart_list li, 
			body .photty_container ul.product_list_widget li {
                color: ' . get_theme_mod('color_main', '#e44b3c') . ';
			}
			body .photty_container ul.cart_list li:first-child, 
			body .photty_container ul.product_list_widget li:first-child {
				
			}
			body .photty_container .widget_shopping_cart .total, 
			.photty_container .woocommerce.widget_shopping_cart .total {
				
			}
			body .photty_container .widget_shopping_cart .total strong, 
			.photty_container .woocommerce.widget_shopping_cart .total strong {
				
			}
			body .photty_container .widget_price_filter .price_slider_wrapper .ui-widget-content {
                background: #e8eaee;
			}
			body .photty_container .widget_price_filter .ui-slider .ui-slider-handle,
			body .photty_container .widget_price_filter .ui-slider .ui-slider-range {
                background: ' . get_theme_mod('color_main', '#e44b3c') . ';
			}
			
			.woocommerce ul.products li.product .onsale,
			.photty_tiny .product .onsale {
                background: ' . get_theme_mod('color_main', '#e44b3c') . ';
                color: ' . get_theme_mod('body_bg_color', '#ffffff') . ';
			}
			
			.woocommerce ul.products li.product a .woocommerce-loop-product__title,
			body.woocommerce .photty_container ul.products li.product a .woocommerce-loop-category__title, 
			body.woocommerce .photty_container ul.products li.product a .woocommerce-loop-product__title, 
			body.woocommerce .photty_container ul.products li.product a h3 {
                color: ' . get_theme_mod('color_headings') . ';
			}
			.woocommerce ul.products li.product a:hover .woocommerce-loop-product__title,
			body.woocommerce .photty_container ul.products li.product a:hover .woocommerce-loop-category__title, 
			body.woocommerce .photty_container ul.products li.product a:hover .woocommerce-loop-product__title, 
			body.woocommerce .photty_container ul.products li.product a:hover h3 {
                color: ' . get_theme_mod('color_main', '#e44b3c') . ';
			}
			
			body .wp-block-woocommerce-products ul.products li.product span.price,
			body .wp-block-woocommerce-products ul.products li.product span.price > del,
			body .wp-block-woocommerce-products ul.products li.product span.price > ins,
			body.woocommerce .photty_container div.product p.price,
			body.woocommerce .photty_container div.product span.price,
			body.woocommerce .photty_container div.product p.price > del, 
			body.woocommerce .photty_container div.product span.price > del,
			body.woocommerce .photty_container div.product p.price > ins, 
			body.woocommerce .photty_container div.product span.price > ins,
			body.woocommerce .photty_container div.product p.price > span, 
			body.woocommerce .photty_container div.product span.price > span,        
			body.woocommerce .photty_container ul.products li.product .price,
			body.woocommerce .photty_container ul.products li.product .price > del,
			body.woocommerce .photty_container ul.products li.product .price > ins,
			body.woocommerce .photty_container ul.products li.product .price > span {
                color: ' . get_theme_mod('color_main', '#e44b3c') . ';
			}
			body.woocommerce .photty_container .woocommerce-result-count, 
			body.woocommerce-page .photty_container .woocommerce-result-count {
                font-family: "' . get_theme_mod('main_font_family', 'Roboto') . '";
                font-size: ' . absint(get_theme_mod('main_font_size', '14')) . 'px;
                line-height: ' . absint(get_theme_mod('main_line_height', '22')) . 'px;
                font-weight: ' . absint(get_theme_mod('main_font_weight', '400')) . ';
                color: ' . get_theme_mod('color_content', '#737479') . ';
			}
			            
			.woocommerce a.remove,
			body .photty_container .widget_shopping_cart .cart_list li a.remove, 
			.photty_container .woocommerce.widget_shopping_cart .cart_list li a.remove {
                background-color: rgba(' . photty_hex2rgb(get_theme_mod('color_main', '#e44b3c')) . ', 0);
			}
			.woocommerce a.remove:hover,
			body .photty_container .widget_shopping_cart .cart_list li a.remove:hover, 
			.photty_container .woocommerce.widget_shopping_cart .cart_list li a.remove:hover {
                background-color: rgba(' . photty_hex2rgb(get_theme_mod('color_main', '#e44b3c')) . ', 1);
			}
            
            html #add_payment_method #payment div.payment_box, 
            html .woocommerce-cart #payment div.payment_box, 
            html .woocommerce-checkout #payment div.payment_box {
                background: '. get_theme_mod('color_main', '#e44b3c') .';
                color: ' . get_theme_mod('body_bg_color', '#ffffff') . ';
            }
            #add_payment_method #payment div.payment_box::before, 
            .woocommerce-cart #payment div.payment_box::before, 
            .woocommerce-checkout #payment div.payment_box::before {
                border-color: transparent transparent '. get_theme_mod('color_main', '#e44b3c') .' transparent;
            }
            
            body nav.woocommerce-MyAccount-navigation ul a:hover,
            html nav.woocommerce-MyAccount-navigation ul li.is-active a {
                color: ' . get_theme_mod('color_main', '#e44b3c') . ';
            }
            
            body.woocommerce p.stars a {
                color: ' . get_theme_mod('color_main', '#e44b3c') . ';
            }

            body.woocommerce .photty_container div.product .woocommerce-tabs ul.tabs li {
                border: 2px solid ' . get_theme_mod('color_main', '#e44b3c') . ';
                border-bottom: none;
            }
            html .woocommerce div.product div.woocommerce-tabs ul.tabs:before {
                border-bottom: 2px solid ' . get_theme_mod('color_main', '#e44b3c') . ';
            }            
            
            body.woocommerce .photty_container div.product .woocommerce-tabs ul.tabs li,
            .woocommerce div.product .woocommerce-tabs ul.tabs li.active {
                background: ' . get_theme_mod('body_bg_color', '#ffffff') . ';
            }
            
            .woocommerce div.product .woocommerce-tabs ul.tabs li:hover a {
                background: ' . get_theme_mod('color_main', '#e44b3c') . ';
                color: ' . get_theme_mod('body_bg_color', '#ffffff') . ';
            }
            .woocommerce div.product .woocommerce-tabs ul.tabs li.active:hover a {
                background: ' . get_theme_mod('body_bg_color', '#ffffff') . ';
                color: ' . get_theme_mod('color_main', '#e44b3c') . ';
            }
            .woocommerce div.product .woocommerce-tabs ul.tabs li.active::before {
                box-shadow: 2px 2px 0 ' . get_theme_mod('body_bg_color', '#ffffff') . ';
            }
            body.woocommerce #reviews #comments ol.commentlist li .comment-text div.star-rating {
                color: ' . get_theme_mod('color_main', '#e44b3c') . ';
            }
            
            body.woocommerce #reviews #comments ol.commentlist li .comment-text .woocommerce-review__author,
            body.woocommerce #reviews #comments ol.commentlist li .comment-text .woocommerce-review__published-date {
                color: ' . get_theme_mod('color_headings', '#2b2d38') . ';
            }
            .blockUI.blockOverlay {
                background: ' . get_theme_mod('body_bg_color', '#ffffff') . '!important;
            }
            
            html .woocommerce div.product p.stock,
            .photty_container div.product .summary.entry-summary .woocommerce-product-rating:after,
            body.woocommerce .woocommerce-product-rating .star-rating,
            html .woocommerce a:hover {
                color: ' . get_theme_mod('color_main', '#e44b3c') . ';
            }
		';	
	}
	
    echo '</style>';
}