<?php

/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
if (function_exists('vc_map')) {
    vc_map(array(
        'base' => 'pm_vc_works_slider',
        'name' => esc_html__('Works Slider', 'photty'),
        'description' => esc_html__('Display Works Slider slider', 'photty'),
        'category' => esc_html__('Pixel-Mafia', 'photty'),
        'as_parent' => array('only' => 'pm_vc_works_slider_item'),
        'content_element' => true,
        'is_container' => true,
        'icon' => 'pm_vc_elements_icon pm_works_slider',
        'show_settings_on_create' => false,
        'params' => array(
			array(
				'type' => 'checkbox',
				'heading' => esc_html__('Autoplay', 'photty'),
				'param_name' => 'autoplay',
				'description' => esc_html__( 'Enable slider autoplay.', 'photty' ),
				'value' => esc_html__('Yes', 'photty')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Autoplay Speed,", "photty"),
				"param_name" => "autoplay_speed",
				"value" => '5000',
                'dependency' => array(
                    'element' => 'autoplay',
                    'value' => 'true'
                )
			),
			
            array(
                'type' => 'css_editor',
                'heading' => esc_html__('CSS', 'photty'),
                'param_name' => 'custom_css'
            ),
            array(
                'param_name' => 'custom_class',
                'heading' => esc_html__('Custom Class', 'photty'),
                'description' => '',
                'type' => 'textfield',
                'value' => '',
                'admin_label' => false,
                'weight' => 0,
            )
        ),
        'js_view' => 'VcColumnView'
    ));
}

if (class_exists('WPBakeryShortCodesContainer')) {
    class WPBakeryShortCode_PM_VC_Works_Slider extends WPBakeryShortCodesContainer
    {
    }
}


# Works Slider Item
if (function_exists('vc_map')) {
    vc_map(array(
        'base' => 'pm_vc_works_slider_item',
        'name' => esc_html__('Works Slider Item', 'photty'),
        "description" => esc_html__("Create item for Works Slider", "photty"),
        'category' => esc_html__('Pixel-Mafia', 'photty'),
        'icon' => 'pm_vc_elements_icon pm_works_slider_item',
        "as_child" => array('only' => 'pm_vc_works_slider'),
        'is_container' => false,
        'show_settings_on_create' => true,
        'params' => array(
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Featured Image', 'photty'),
				'param_name' => 'image',
				'admin_label' => true,
				'description' => esc_html__('Select featured image from media library.', 'photty'),
				'value' => ''
			),		
			array(
				'type' => 'checkbox',
				'heading' => esc_html__('Crop Image?', 'photty'),
				'param_name' => 'image_crop',
				'description' => esc_html__( 'Enable slider autoplay.', 'photty' ),
				'value' => esc_html__('Yes', 'photty')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Image Width", "photty"),
				"param_name" => "image_crop_width",
				"value" => '1170',
				'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'image_crop',
                    'value' => 'true'
                )
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Crop Height", "photty"),
				"param_name" => "image_crop_height",
				"value" => '700',
				'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'image_crop',
                    'value' => 'true'
                )
			),
			
			array(
				'type' => 'checkbox',
				'heading' => esc_html__('Use custom image title?', 'photty'),
				'param_name' => 'custom_title_state',
				'value' => esc_html__('Yes', 'photty')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Custom Title", "photty"),
				"param_name" => "custom_title",
				"value" => '',
                'dependency' => array(
                    'element' => 'custom_title_state',
                    'value' => 'true'
                )
			),
			array(
				"type" => "colorpicker",
				"heading" => esc_html__("Image Title Color", "photty"),
				"param_name" => "title_color",
				"value" => "",
				"description" => esc_html__("Select text color for testimonial text.", "photty"),
				'edit_field_class' => 'vc_col-sm-6',
			),
			
            array(
                "type" => "textfield",
                "heading" => esc_html__("Option 1 Title", "photty"),
                "param_name" => "option1_title",
                'value' => '',
				'edit_field_class' => 'photty_vc_ws_title'
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Option 1 Text", "photty"),
                "param_name" => "option1_caption",
                'value' => '',
				'edit_field_class' => 'photty_vc_ws_text'
            ),

            array(
                "type" => "textfield",
                "heading" => esc_html__("Option 2 Title", "photty"),
                "param_name" => "option2_title",
                'value' => '',
				'edit_field_class' => 'photty_vc_ws_title'
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Option 2 Text", "photty"),
                "param_name" => "option2_caption",
                'value' => '',
				'edit_field_class' => 'photty_vc_ws_text'
            ),

            array(
                "type" => "textfield",
                "heading" => esc_html__("Option 3 Title", "photty"),
                "param_name" => "option3_title",
                'value' => '',
				'edit_field_class' => 'photty_vc_ws_title'
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Option 3 Text", "photty"),
                "param_name" => "option3_caption",
                'value' => '',
				'edit_field_class' => 'photty_vc_ws_text'
            ),

            array(
                "type" => "textfield",
                "heading" => esc_html__("Option 4 Title", "photty"),
				"param_name" => "option4_title",
                'value' => '',
				'edit_field_class' => 'photty_vc_ws_title'
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Option 4 Text", "photty"),
                "param_name" => "option4_caption",
                'value' => '',
				'edit_field_class' => 'photty_vc_ws_text'
            ),

            array(
                "type" => "textarea",
                "heading" => esc_html__("Item Description", "photty"),
                "param_name" => "description",
                'value' => ''
            ),
            array(
                'param_name' => 'custom_class',
                'heading' => esc_html__('Custom Class', 'photty'),
                'description' => '',
                'type' => 'textfield',
                'value' => '',
                'admin_label' => false,
                'weight' => 0,
            )
        )
    ));
}
if (class_exists('WPBakeryShortCode')) {
    class WPBakeryShortCode_PM_VC_Works_Slider_Item extends WPBakeryShortCode
    {
    }
}
?>