<?php

/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
if (function_exists('vc_map')) {
    vc_map(array(
        'base' => 'pm_vc_testimonials',
        'name' => esc_html__('Testimonials', 'photty'),
        'description' => esc_html__('Display Testimonials slider', 'photty'),
        'category' => esc_html__('Pixel-Mafia', 'photty'),
        'as_parent' => array('only' => 'pm_vc_testimonials_item'),
        'content_element' => true,
        'is_container' => true,
        'icon' => 'pm_vc_elements_icon pm_testimonials',
        'show_settings_on_create' => false,
        'params' => array(
			array(
				'type' => 'checkbox',
				'heading' => esc_html__('Autoplay', 'photty'),
				'param_name' => 'autoplay',
				'description' => esc_html__( 'Enable slider autoplay.', 'photty' ),
				'value' => esc_html__('Yes', 'photty')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Autoplay Speed", "photty"),
				"param_name" => "autoplay_speed",
				"value" => '5000',
                'dependency' => array(
                    'element' => 'autoplay',
                    'value' => 'true'
                )
			),
			
            array(
                'type' => 'css_editor',
                'heading' => esc_html__('CSS', 'photty'),
                'param_name' => 'custom_css'
            ),
            array(
                'param_name' => 'custom_class',
                'heading' => esc_html__('Custom Class', 'photty'),
                'description' => '',
                'type' => 'textfield',
                'value' => '',
                'admin_label' => false,
                'weight' => 0,
            )
        ),
        'js_view' => 'VcColumnView'
    ));
}

if (class_exists('WPBakeryShortCodesContainer')) {
    class WPBakeryShortCode_PM_VC_Testimonials extends WPBakeryShortCodesContainer
    {
    }
}


# Testimonials Item
if (function_exists('vc_map')) {
    vc_map(array(
        'base' => 'pm_vc_testimonials_item',
        'name' => esc_html__('Testimonials Item', 'photty'),
        "description" => esc_html__("Create testimonial item", "photty"),
        'category' => esc_html__('Pixel-Mafia', 'photty'),
        'icon' => 'pm_vc_elements_icon pm_testimonials_item',
        "as_child" => array('only' => 'pm_vc_testimonials'),
        'is_container' => false,
        'show_settings_on_create' => true,
        'params' => array(
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Featured Image', 'photty'),
				'param_name' => 'testimonial_image',
				'admin_label' => true,
				'description' => esc_html__('Select featured image from media library.', 'photty'),
				'value' => ''
			),		
            array(
                "type" => "textarea",
                "heading" => esc_html__("Testimonial Text", "photty"),
                "param_name" => "testimonial_text",
                'value' => ''
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Author", "photty"),
                "param_name" => "testimonial_author",
                'value' => ''
            ),
			array(
				"type" => "colorpicker",
				"heading" => esc_html__("Text Color", "photty"),
				"param_name" => "text_color",
				"value" => "",
				"description" => esc_html__("Select text color for testimonial text.", "photty"),
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				"type" => "colorpicker",
				"heading" => esc_html__("Author Color", "photty"),
				"param_name" => "author_color",
				"value" => "",
				"description" => esc_html__("Select text color for testimonial author.", "photty"),
				'edit_field_class' => 'vc_col-sm-6',
			),
			
            array(
                'param_name' => 'custom_class',
                'heading' => esc_html__('Custom Class', 'photty'),
                'description' => '',
                'type' => 'textfield',
                'value' => '',
                'admin_label' => false,
                'weight' => 0,
            )
        )
    ));
}
if (class_exists('WPBakeryShortCode')) {
    class WPBakeryShortCode_PM_VC_Testimonials_Item extends WPBakeryShortCode
    {
    }
}
?>