<?php

/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
if (function_exists('vc_map')) {
    vc_map(array(
        'base' => 'pm_vc_stripes',
        'name' => esc_html__('Stripes', 'photty'),
        'description' => esc_html__('Display stripe slider', 'photty'),
        'category' => esc_html__('Pixel-Mafia', 'photty'),
        'as_parent' => array('only' => 'pm_vc_stripes_item'),
        'content_element' => true,
        'is_container' => true,
        'icon' => 'pm_vc_elements_icon pm_stripes',
        'show_settings_on_create' => true,
        'params' => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Select Layout', 'photty'),
				'param_name' => 'fullscreen_layout',
				'admin_label' => true,
				'std' => 'on',
				'value' => array(
					esc_html__("Fullscreen Layout", "photty") => 'on',
					esc_html__("Content Layout", "photty") => 'off'
				)
			),		
            array(
                'type' => 'css_editor',
                'heading' => esc_html__('CSS', 'photty'),
                'param_name' => 'custom_css'
            ),
            array(
                'param_name' => 'custom_class',
                'heading' => esc_html__('Custom Class', 'photty'),
                'description' => '',
                'type' => 'textfield',
                'value' => '',
                'admin_label' => false,
                'weight' => 0,
            )
        ),
        'js_view' => 'VcColumnView'
    ));
}

if (class_exists('WPBakeryShortCodesContainer')) {
    class WPBakeryShortCode_PM_VC_Stripes extends WPBakeryShortCodesContainer
    {
    }
}


# Price Table Item
if (function_exists('vc_map')) {
    vc_map(array(
        'base' => 'pm_vc_stripes_item',
        'name' => esc_html__('Stripe Item', 'photty'),
        "description" => esc_html__("Create sprite slide", "photty"),
        'category' => esc_html__('Pixel-Mafia', 'photty'),
        'icon' => 'pm_vc_elements_icon pm_stripes_item',
        "as_child" => array('only' => 'pm_vc_stripes'),
        'is_container' => false,
        'show_settings_on_create' => true,
        'params' => array(
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Item Background Image', 'photty'),
				'param_name' => 'item_image',
				'admin_label' => true,
				'description' => esc_html__('Select featured image from media library.', 'photty'),
				'value' => ''
			),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Title", "photty"),
                "param_name" => "item_title",
                'value' => ''
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Description", "photty"),
                "param_name" => "item_description",
                'value' => ''
            ),
			array(
				"type" => "colorpicker",
				"heading" => esc_html__("Title Color", "photty"),
				"param_name" => "title_color",
				"value" => "",
				'edit_field_class' => 'vc_col-sm-6',
				"description" => esc_html__("Select Title color.", "photty"),				
			),
			array(
				"type" => "colorpicker",
				"heading" => esc_html__("Description Color", "photty"),
				"param_name" => "descr_color",
				"value" => "",
				'edit_field_class' => 'vc_col-sm-6',
				"description" => esc_html__("Select Description color.", "photty"),				
			),
			
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Link Type', 'photty'),
				'param_name' => 'link_type',
				'admin_label' => true,
				'std' => 'none',
				'value' => array(
					esc_html__("None", "photty") => 'none',
					esc_html__("Link on whole item", "photty") => 'link_all_item',
					esc_html__("Link on button", "photty") => 'link_by_button'
				)
			),	
            array(
                "type" => "textfield",
                "heading" => esc_html__("Button Text", "photty"),
                "param_name" => "button_text",
                'value' => '',
				'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'link_type',
                    'value' => 'link_by_button'
                )
            ),
            array(
				"type" => "colorpicker",
				"heading" => esc_html__("Button Text Color", "photty"),
				"param_name" => "button_color",
				"value" => "",
				'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'link_type',
                    'value' => 'link_by_button'
                )
            ),
            array(
                "type" => "vc_link",
                "heading" => esc_html__("Item Link", "photty"),
                "param_name" => "item_link",
                'value' => '',
                'dependency' => array(
                    'element' => 'link_type',
                    'value' => array('link_all_item','link_by_button')
                )
            ),			
						
            array(
                'param_name' => 'custom_class',
                'heading' => esc_html__('Custom Class', 'photty'),
                'description' => '',
                'type' => 'textfield',
                'value' => '',
                'admin_label' => false,
                'weight' => 0,
            )
        )
    ));
}
if (class_exists('WPBakeryShortCode')) {
    class WPBakeryShortCode_PM_VC_Stripes_Item extends WPBakeryShortCode
    {
    }
}
?>