<?php

/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
if (function_exists('vc_map')) {
	vc_map(array(
		'base' => 'pm_vc_simple_slider',
		'name' => esc_html__('Simple Slider', 'photty'),
		"description" => esc_html__("Display image carousel", "photty"),
		'category' => esc_html__('Pixel-Mafia', 'photty'),
		'icon' => 'photty_vc_elements_icon photty_image_carousel',
		'params' => array(
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Add Images', 'photty'),
				'param_name' => 'images',
				'admin_label' => true,
				'description' => esc_html__('Select images from media library.', 'photty'),
				'value' => ''
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Enter Slider Height", "photty"),
				"param_name" => "slider_height",
				'description' => esc_html__('Slider Module height in PX or 100% to set fullscreen height.', 'photty'),
				'value' => '800px'
			),				
			array(
				"type" => "colorpicker",
				"heading" => esc_html__("Overlay Background Color", "photty"),
				"param_name" => "overlay_bg",
				"value" => "",
				"description" => esc_html__("Select overlay background color.", "photty"),
			),			
			array(
				"type" => "textfield",
				"heading" => esc_html__("Autoplay Speed,", "photty"),
				"param_name" => "autoplay_speed",
				"value" => '5000',
			),

            array(
                "type" => "textfield",
                "heading" => esc_html__("Title", "photty"),
                "param_name" => "item_title",
                'value' => ''
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Title Tag', 'photty'),
				'param_name' => 'title_tag',
				'admin_label' => true,
				'value' => array(
					esc_html__("H1", "photty") => 'h1',
					esc_html__("H2", "photty") => 'h2',
					esc_html__("H3", "photty") => 'h3',
					esc_html__("H4", "photty") => 'h4',
					esc_html__("H5", "photty") => 'h5',
					esc_html__("H6", "photty") => 'h6',
				)
			),			
            array(
                "type" => "textfield",
                "heading" => esc_html__("Caption", "photty"),
                "param_name" => "item_caption",
                'value' => ''
            ),

			array(
				"type" => "colorpicker",
				"heading" => esc_html__("Title Color", "photty"),
				"param_name" => "title_color",
				"value" => "",
				'std' => '#ffffff',
				'edit_field_class' => 'vc_col-sm-6',
				"description" => esc_html__("Select title color.", "photty"),
			),			
			array(
				"type" => "colorpicker",
				"heading" => esc_html__("Caption Color", "photty"),
				"param_name" => "caption_color",
				'std' => '#ffffff',
				"value" => "",
				'edit_field_class' => 'vc_col-sm-6',
				"description" => esc_html__("Select title color.", "photty"),
			),			
			
            array(
                'type' => 'checkbox',
                'heading' => esc_html__('Add Button?', 'photty'),
                'param_name' => 'button_state',
                'value' => esc_html__('Yes', 'photty'),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Button Text", "photty"),
                "param_name" => "button_text",
                'value' => '',
                'dependency' => array(
                    'element' => 'button_state',
                    'value' => 'true'
                )
            ),
            array(
                "type" => "vc_link",
                "heading" => esc_html__("Button Link", "photty"),
                "param_name" => "button_link",
                'value' => '',
                'dependency' => array(
                    'element' => 'button_state',
                    'value' => 'true'
                )
            ),
			
			array(
				'type' => 'css_editor',
				'heading' => esc_html__('CSS', 'photty'),
				'param_name' => 'custom_css',
				'group' => esc_html__('Design options', 'photty'),
			),

			array(
				'param_name' => 'custom_class',
				'heading' => esc_html__('Custom Class', 'photty'),
				'description' => '',
				'type' => 'textfield',
				'value' => '',
				'admin_label' => false,
				'weight' => 0,
				'group' => 'Design options',
			)		
		)
	));

}

if (class_exists('WPBakeryShortCode')) {
    class WPBakeryShortCode_PM_vc_Simple_Slider extends WPBakeryShortCode
    {
    }
}
?>