<?php

/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
if (function_exists('vc_map')) {
	vc_map(array(
		'base' => 'pm_vc_promo_text',
		'name' => esc_html__('Promo Text', 'photty'),
		"description" => esc_html__("Display promo text block", "photty"),
		'category' => esc_html__('Pixel-Mafia', 'photty'),
		'icon' => 'photty_vc_elements_icon photty_promo_text',
		'params' => array(
			array(
				"type" => "textfield",
				"heading" => esc_html__("Promo Title", "photty"),
				"param_name" => "promo_title",
				'value' => ''
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Promo Title Tag', 'photty'),
				'param_name' => 'title_tag',
				'admin_label' => true,
				'value' => array(
					esc_html__("H1", "photty") => 'h1',
					esc_html__("H2", "photty") => 'h2',
					esc_html__("H3", "photty") => 'h3',
					esc_html__("H4", "photty") => 'h4',
					esc_html__("H5", "photty") => 'h5',
					esc_html__("H6", "photty") => 'h6',
				)
			),
			
			array(
				"type" => "textarea",
				"heading" => esc_html__("Promo Text", "photty"),
				"param_name" => "promo_text",
				'value' => ''
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Promo Text Tag', 'photty'),
				'param_name' => 'text_tag',
				'admin_label' => true,
				'value' => array(
					esc_html__("DIV", "photty") => 'div',
					esc_html__("P", "photty") => 'p',
					esc_html__("H2", "photty") => 'h2',
					esc_html__("H3", "photty") => 'h3',
					esc_html__("H4", "photty") => 'h4',
					esc_html__("H5", "photty") => 'h5',
					esc_html__("H6", "photty") => 'h6',
				)
			),			
            array(
                'type' => 'checkbox',
                'heading' => esc_html__('Add Button?', 'photty'),
                'param_name' => 'button_state',
                'value' => esc_html__('Yes', 'photty'),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Button Text", "photty"),
                "param_name" => "button_text",
                'value' => '',
                'dependency' => array(
                    'element' => 'button_state',
                    'value' => 'true'
                )
            ),
            array(
                "type" => "vc_link",
                "heading" => esc_html__("Button Link", "photty"),
                "param_name" => "button_link",
                'value' => '',
                'dependency' => array(
                    'element' => 'button_state',
                    'value' => 'true'
                )
            ),

			
			array(
				'type' => 'css_editor',
				'heading' => esc_html__('CSS', 'photty'),
				'param_name' => 'custom_css',
				'group' => esc_html__('Design options', 'photty'),
			),

			array(
				'param_name' => 'custom_class',
				'heading' => esc_html__('Custom Class', 'photty'),
				'description' => '',
				'type' => 'textfield',
				'value' => '',
				'admin_label' => false,
				'weight' => 0,
				'group' => 'Design options',
			)		
		)
	));

}

if (class_exists('WPBakeryShortCode')) {
    class WPBakeryShortCode_PM_VC_promo_text extends WPBakeryShortCode
    {
    }
}
?>