<?php

/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
if (function_exists('vc_map')) {
    vc_map(array(
        'base' => 'pm_vc_price_table',
        'name' => esc_html__('Price Table', 'photty'),
        'description' => esc_html__('Display price table', 'photty'),
        'category' => esc_html__('Pixel-Mafia', 'photty'),
        'as_parent' => array('only' => 'pm_vc_price_table_item'),
        'content_element' => true,
        'is_container' => true,
        'icon' => 'pm_vc_elements_icon pm_price_table',
        'show_settings_on_create' => false,
        'params' => array(
            array(
                'type' => 'css_editor',
                'heading' => esc_html__('CSS', 'photty'),
                'param_name' => 'custom_css'
            ),
            array(
                'param_name' => 'custom_class',
                'heading' => esc_html__('Custom Class', 'photty'),
                'description' => '',
                'type' => 'textfield',
                'value' => '',
                'admin_label' => false,
                'weight' => 0,
            )
        ),
        'js_view' => 'VcColumnView'
    ));
}

if (class_exists('WPBakeryShortCodesContainer')) {
    class WPBakeryShortCode_PM_VC_Price_Table extends WPBakeryShortCodesContainer
    {
    }
}


# Price Table Item
if (function_exists('vc_map')) {
    vc_map(array(
        'base' => 'pm_vc_price_table_item',
        'name' => esc_html__('Price Table Item', 'photty'),
        "description" => esc_html__("Create price table item", "photty"),
        'category' => esc_html__('Pixel-Mafia', 'photty'),
        'icon' => 'pm_vc_elements_icon pm_price_table_item',
        "as_child" => array('only' => 'pm_vc_price_table'),
        'is_container' => false,
        'show_settings_on_create' => true,
        'params' => array(
            array(
                "type" => "textfield",
                "heading" => esc_html__("Title", "photty"),
                "param_name" => "item_title",
                'value' => ''
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Currency", "photty"),
                "param_name" => "item_currency",
                'edit_field_class' => 'vc_col-sm-3',
                'value' => '$'
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Price", "photty"),
                "param_name" => "item_price",
                'edit_field_class' => 'vc_col-sm-6',
                'value' => ''
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Period", "photty"),
                "param_name" => "item_period",
                'edit_field_class' => 'vc_col-sm-3',
                'value' => '/mo'
            ),
            array(
                "type" => "textarea",
                "heading" => esc_html__("Description", "photty"),
                "param_name" => "item_descr",
                'value' => ''
            ),
            array(
                'type' => 'checkbox',
                'heading' => esc_html__('Add Button?', 'photty'),
                'param_name' => 'button_state',
                'value' => esc_html__('Yes', 'photty'),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Button Text", "photty"),
                "param_name" => "button_text",
                'value' => '',
                'dependency' => array(
                    'element' => 'button_state',
                    'value' => 'true'
                )
            ),
            array(
                "type" => "vc_link",
                "heading" => esc_html__("Button Link", "photty"),
                "param_name" => "button_link",
                'value' => '',
                'dependency' => array(
                    'element' => 'button_state',
                    'value' => 'true'
                )
            ),
            array(
                'type' => 'checkbox',
                'heading' => esc_html__('Most Popular Item?', 'photty'),
                'param_name' => 'most_popular',
                'value' => esc_html__('Yes', 'photty'),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Most Popular Label Text", "photty"),
                "param_name" => "mp_label",
                'value' => 'popular',
                'dependency' => array(
                    'element' => 'most_popular',
                    'value' => 'true'
                )
            ),
            array(
                'param_name' => 'custom_class',
                'heading' => esc_html__('Custom Class', 'photty'),
                'description' => '',
                'type' => 'textfield',
                'value' => '',
                'admin_label' => false,
                'weight' => 0,
            )
        )
    ));
}
if (class_exists('WPBakeryShortCode')) {
    class WPBakeryShortCode_PM_VC_Price_Table_Item extends WPBakeryShortCode
    {
    }
}
?>