<?php

/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
if (function_exists('vc_map')) {
	vc_map(array(
		'base' => 'pm_vc_image_carousel',
		'name' => esc_html__('Image Carousel', 'photty'),
		"description" => esc_html__("Display image carousel", "photty"),
		'category' => esc_html__('Pixel-Mafia', 'photty'),
		'icon' => 'photty_vc_elements_icon photty_image_carousel',
		'params' => array(
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Add Images', 'photty'),
				'param_name' => 'images',
				'admin_label' => true,
				'description' => esc_html__('Select images from media library.', 'photty'),
				'value' => ''
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Enter thumbnail width", "photty"),
				"param_name" => "img_width",
				'edit_field_class' => 'vc_col-sm-6',
				'value' => '500'
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Enter thumbnail height", "photty"),
				"param_name" => "img_height",
				'edit_field_class' => 'vc_col-sm-6',
				'value' => '500'
			),				
			array(
				"type" => "textfield",
				"heading" => esc_html__("Images on screen", "photty"),
				"param_name" => "on_screen",
				'value' => '4'
			),				
			array(
				'type' => 'checkbox',
				'heading' => esc_html__('Open in Lightbox', 'photty'),
				'param_name' => 'lightbox',
				'description' => esc_html__( 'If checked, on click images will be open in Lightbox', 'photty' ),
				'value' => esc_html__('Yes', 'photty'),
			),
			array(
				"type" => "colorpicker",
				"heading" => esc_html__("Overlay Background Color", "photty"),
				"param_name" => "overlay_bg",
				"value" => "",
				"description" => esc_html__("Select overlay background color on hover.", "photty"),
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Paddings around the images", "photty"),
				"param_name" => "items_padding",
				'edit_field_class' => 'vc_col-sm-6',
				'description' => esc_html__('Please use this option to add paddings around the images. Recommended size in pixels 0-50. (Ex.: 15px):', 'photty'),
				'value' => '15px'
			),
			
			array(
				'type' => 'checkbox',
				'heading' => esc_html__('Autoplay', 'photty'),
				'param_name' => 'autoplay',
				'description' => esc_html__( 'Enable slider autoplay.', 'photty' ),
				'value' => esc_html__('Yes', 'photty'),
				'edit_field_class' => 'vc_col-sm-6'
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Autoplay Speed,", "photty"),
				"param_name" => "autoplay_speed",
				"value" => '5000',
				'edit_field_class' => 'vc_col-sm-6'
			),
			
			array(
				'type' => 'css_editor',
				'heading' => esc_html__('CSS', 'photty'),
				'param_name' => 'custom_css',
				'group' => esc_html__('Design options', 'photty'),
			),

			array(
				'param_name' => 'custom_class',
				'heading' => esc_html__('Custom Class', 'photty'),
				'description' => '',
				'type' => 'textfield',
				'value' => '',
				'admin_label' => false,
				'weight' => 0,
				'group' => 'Design options',
			)		
		)
	));

}

if (class_exists('WPBakeryShortCode')) {
    class WPBakeryShortCode_PM_VC_Image_Carousel extends WPBakeryShortCode
    {
    }
}
?>