<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/
if (function_exists('vc_map')) {
	vc_map(
		array(
			'name' => esc_html__('Blog Grid', 'photty'),
			'base' => 'pm_vc_blog_grid',
			'description' => 'Display blog posts in grid layout.',
			'category' => esc_html__('Pixel-Mafia', 'photty'),
			'icon' => 'photty_vc_elements_icon photty_blog_grid',
			'params' => array(
				array(
					'type' => 'dropdown',
					'heading' => esc_html__('Items in Row', 'photty'),
					'param_name' => 'items_in_row',
					'admin_label' => true,
					'std' => '3',
					'value' => array(
						esc_html__("1 Item", "photty") => '1',
						esc_html__("2 Items", "photty") => '2',
						esc_html__("3 Items", "photty") => '3',
						esc_html__("4 Item", "photty") => '4',
						esc_html__("5 Items", "photty") => '5',
						esc_html__("6 Items", "photty") => '6'
					)
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Enter post thumbnail width", "photty"),
					"param_name" => "thmb_width",
					'edit_field_class' => 'vc_col-sm-6',
					'value' => '800'
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Enter post thumbnail height", "photty"),
					"param_name" => "thmb_height",
					'edit_field_class' => 'vc_col-sm-6',
					'value' => '600'
				),				
				array(
					"type" => "textfield",
					"heading" => esc_html__("Items on First Load", "photty"),
					"param_name" => "posts_first_load",
					'edit_field_class' => 'vc_col-sm-6',
					'value' => '9'
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Items on Load More", "photty"),
					"param_name" => "items_per_load",
					'edit_field_class' => 'vc_col-sm-6',
					'value' => '3'
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Paddings around the images", "photty"),
					"param_name" => "items_padding",
					'description' => esc_html__('Please use this option to add paddings around the images. Recommended size in pixels 0-50. (Ex.: 15px):', 'photty'),
					'value' => '30px'
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Load More Button Text", "photty"),
					"param_name" => "button_title",
					"description" => esc_html__("Specify Load More button text", "photty"),
					"value" => esc_html__("Load More", "photty")
				),

				array(
					'type' => 'css_editor',
					'heading' => esc_html__('CSS', 'photty'),
					'param_name' => 'custom_css',
					'group' => esc_html__('Design options', 'photty'),
				),

				array(
					'param_name' => 'custom_class',
					'heading' => esc_html__('Custom Class', 'photty'),
					'description' => '',
					'type' => 'textfield',
					'value' => '',
					'admin_label' => false,
					'weight' => 0,
					'group' => 'Design options',
				),

			)
		)
	);
}


if (class_exists('WPBakeryShortCode')) {
    class WPBakeryShortCode_PM_VC_Blog_Grid extends WPBakeryShortCode
    {
    }
}
