<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

if (!class_exists('RWMB_Loader')) {
    return;
}

add_filter('rwmb_meta_boxes', 'photty_meta_boxes');
function photty_meta_boxes($meta_boxes)
{
    # Image Post Format
    $meta_boxes[] = array(
        'title' => esc_attr__('Image Post Format Settings', 'photty'),
        'post_types' => 'post',
        'fields' => array(
            array(
                'id' => 'photty_pf_images',
                'name' => esc_attr__('Select Images', 'photty'),
                'type' => 'image_advanced',
            ),
            array(
                'id' => 'photty_pf_images_crop_status',
                'name' => esc_attr__('Crop Images', 'photty'),
                'type' => 'select',
                'options' => array(
                    'yes' => esc_attr__('Yes', 'photty'),
                    'no' => esc_attr__('No', 'photty'),
                ),
            ),
            array(
                'id' => 'photty_pf_images_width',
                'name' => esc_attr__('Image Width', 'photty'),
                'type' => 'text',
                'desc' => esc_attr__('In pixels.', 'photty'),
                'std' => '1600',
                'attributes' => array(
                    'data-dependency-id' => 'photty_pf_images_crop_status',
                    'data-dependency-val' => 'yes'
                ),
            ),
            array(
                'id' => 'photty_pf_images_height',
                'name' => esc_attr__('Image Height', 'photty'),
                'type' => 'text',
                'desc' => esc_attr__('In pixels.', 'photty'),
                'std' => '900',
                'attributes' => array(
                    'data-dependency-id' => 'photty_pf_images_crop_status',
                    'data-dependency-val' => 'yes'
                ),
            ),
        ),
    );
	
    # Images for Albums
    $meta_boxes[] = array(
        'title' => esc_attr__('Album Images', 'photty'),
        'post_types' => 'albums',
        'fields' => array(
            array(
                'id' => 'photty_albums_images',
                'name' => esc_attr__('Select Images', 'photty'),
                'type' => 'image_advanced',
            ),
            array(
                'id' => 'photty_albums_images_layout',
                'name' => esc_attr__('Images Layout', 'photty'),
                'type' => 'select',
                'options' => array(
                    '2x1' => esc_attr__('Two and One', 'photty'),
                    '3x2' => esc_attr__('Three and Two', 'photty'),
                ),
            ),
            
            array(
                'id' => 'featured_albums_status',
                'name' => esc_attr__('Featured Albums Status', 'photty'),
                'type' => 'select',
                'options' => array(
                    'default' => esc_attr__('Default', 'photty'),
                    'enabled' => esc_attr__('Enabled', 'photty'),
                    'disabled' => esc_attr__('Disabled', 'photty'),
                ),
            ),
            array(
                'id' => 'featured_albums_orderby',
                'name' => esc_attr__('Featured Albums Order By', 'photty'),
                'type' => 'select',
                'options' => array(
                    'default' => esc_attr__('Default', 'photty'),
                    'rand' => esc_attr__('Random', 'photty'),
                    'date' => esc_attr__('Date', 'photty'),
                ),'attributes' => array(
                    'data-dependency-id' => 'featured_albums_status',
                    'data-dependency-val' => 'enabled'
                ),
            ),
            array(
                'id' => 'featured_albums_numberposts',
                'name' => esc_attr__('Number of Albums', 'photty'),
                'type' => 'select',
                'options' => array(
                    'default' => esc_attr__('Default', 'photty'),
                    '2' => esc_attr__('2 Items', 'photty'),
                    '3' => esc_attr__('3 Items', 'photty'),
                    '4' => esc_attr__('4 Items', 'photty'),
                ),'attributes' => array(
                    'data-dependency-id' => 'featured_albums_status',
                    'data-dependency-val' => 'enabled'
                ),
            ),
        ),
    );

    # Video Post Format
    $meta_boxes[] = array(
        'title' => esc_attr__('Video Post Format Settings', 'photty'),
        'post_types' => 'post',
        'fields' => array(
            array(
                'id' => 'photty_pf_video_url',
                'name' => esc_attr__('Video URL', 'photty'),
                'type' => 'oembed',
                'desc' => esc_attr__('Copy link to the video from YouTube or other video-sharing website.', 'photty'),
            ),
            array(
                'id' => 'photty_pf_video_height',
                'name' => esc_attr__('Video Height', 'photty'),
                'type' => 'text',
                'desc' => esc_attr__('In pixels.', 'photty'),
                'std' => '500',
            ),
        ),
    );

    # Quote Post Format
    $meta_boxes[] = array(
        'title' => esc_attr__('Quote Post Format Settings', 'photty'),
        'post_types' => 'post',
        'fields' => array(
            array(
                'id' => 'photty_pf_quote_text',
                'name' => esc_attr__('Quote Text', 'photty'),
                'type' => 'textarea',
                'std' => ''
            ),
            array(
                'id' => 'photty_pf_quote_author',
                'name' => esc_attr__('Quote Author', 'photty'),
                'type' => 'text',
                'std' => ''
            ),
        ),
    );

    # Audio Post Format
    $meta_boxes[] = array(
        'title' => esc_attr__('Audio Post Format Settings', 'photty'),
        'post_types' => 'post',
        'fields' => array(
            array(
                'id' => 'photty_pf_audio_url',
                'name' => esc_attr__('Audio URL', 'photty'),
                'type' => 'oembed',
                'desc' => esc_attr__('Copy link to the audio from Soundcloud or other audio-sharing website.', 'photty'),
            )
        ),
    );

    # Featured Posts Settings
    $meta_boxes[] = array(
        'title' => esc_attr__('Featured Posts Settings', 'photty'),
        'post_types' => 'post',
        'fields' => array(
            array(
                'id' => 'featured_posts_status',
                'name' => esc_attr__('Featured Posts', 'photty'),
                'type' => 'select',
                'options' => array(
                    'default' => esc_attr__('Default', 'photty'),
                    'enabled' => esc_attr__('Enabled', 'photty'),
                    'disabled' => esc_attr__('Disabled', 'photty'),
                ),
            ),
            array(
                'id' => 'featured_posts_orderby',
                'name' => esc_attr__('Order By', 'photty'),
                'type' => 'select',
                'options' => array(
                    'default' => esc_attr__('Default', 'photty'),
                    'rand' => esc_attr__('Random', 'photty'),
                    'date' => esc_attr__('Date', 'photty'),
                ),
                'attributes' => array(
                    'data-dependency-id' => 'featured_posts_status',
                    'data-dependency-val' => 'enabled'
                ),
            ),
            array(
                'id' => 'featured_posts_numberposts',
                'name' => esc_attr__('Number of Posts', 'photty'),
                'type' => 'select',
                'options' => array(
                    'default' => esc_attr__('Default', 'photty'),
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                ),
                'attributes' => array(
                    'data-dependency-id' => 'featured_posts_status',
                    'data-dependency-val' => 'enabled'
                ),
            ),
            array(
                'id' => 'featured_posts_fimage_status',
                'name' => esc_attr__('Featured Image', 'photty'),
                'type' => 'select',
                'options' => array(
                    'default' => esc_attr__('Default', 'photty'),
                    'show' => 'Show',
                    'hide' => 'Hide',
                ),
                'attributes' => array(
                    'data-dependency-id' => 'featured_posts_status',
                    'data-dependency-val' => 'enabled'
                ),
            ),
            array(
                'id' => 'featured_posts_meta_status',
                'name' => esc_attr__('Meta', 'photty'),
                'type' => 'select',
                'options' => array(
                    'default' => esc_attr__('Default', 'photty'),
                    'show' => 'Show',
                    'hide' => 'Hide',
                ),
                'attributes' => array(
                    'data-dependency-id' => 'featured_posts_status',
                    'data-dependency-val' => 'enabled'
                ),
            ),
            array(
                'id' => 'featured_posts_excerpt_status',
                'name' => esc_attr__('Excerpt', 'photty'),
                'type' => 'select',
                'options' => array(
                    'default' => esc_attr__('Default', 'photty'),
                    'show' => 'Show',
                    'hide' => 'Hide',
                ),
                'attributes' => array(
                    'data-dependency-id' => 'featured_posts_status',
                    'data-dependency-val' => 'enabled'
                ),
            ),
        ),
    );

    # Page & Post Settings
    $meta_boxes[] = array(
        'title' => esc_attr__('Page Settings', 'photty'),
        'post_types' => array('post', 'page'),
        'fields' => array(
            array(
                'id' => 'header_transparent',
                'name' => esc_attr__('Transparent Header', 'photty'),
                'type' => 'select',
                'options' => array(
                    'default' => esc_attr__('Default', 'photty'),
                    'enabled' => esc_attr__('Enabled', 'photty'),
                    'disabled' => esc_attr__('Disabled', 'photty'),
                )
            ),
            array(
                'id' => 'logo_position',
                'name' => esc_attr__('Logo Position', 'photty'),
                'type' => 'select',
                'options' => array(
                    'default' => esc_attr__('Default', 'photty'),
                    'logo_left' => esc_attr__('Left', 'photty'),
                    'logo_center' => esc_attr__('Center', 'photty'),
                    'logo_right' => esc_attr__('Right', 'photty'),
                ),
            ),
            array(
                'id' => 'header_menu_status',
                'name' => esc_attr__('Header Menu', 'photty'),
                'type' => 'select',
                'options' => array(
                    'show' => esc_attr__('Show', 'photty'),
                    'hide' => esc_attr__('Hide', 'photty'),
                ),
            ),
            array(
                'id' => 'content_layout',
                'name' => esc_attr__('Content Layout', 'photty'),
                'type' => 'select',
                'options' => array(
					'default' => esc_attr__('Default', 'photty'),
                    'clean' => esc_attr__('Clean', 'photty'),
                    'boxed' => esc_attr__('Boxed', 'photty'),
                ),
            ),
            array(
                'id' => 'single_page_title',
                'name' => esc_attr__('Page Title', 'photty'),
                'type' => 'select',
                'options' => array(
                    'show' => esc_attr__('Show', 'photty'),
                    'hide' => esc_attr__('Hide', 'photty'),
                ),
            ),
            array(
                'id' => 'header_padding',
                'name' => esc_attr__('Padding Before Content', 'photty'),
                'type' => 'select',
                'options' => array(
                    'photty_header_padding_yes' => esc_attr__('Yes', 'photty'),
                    'photty_header_padding_no' => esc_attr__('No', 'photty'),
                ),
            ),
            array(
                'id' => 'sidebar_position',
                'name' => esc_attr__('Sidebar Position', 'photty'),
                'type' => 'select',
                'options' => array(
                    'default' => esc_attr__('Default', 'photty'),
                    'photty_left_sidebar' => esc_attr__('Left', 'photty'),
                    'photty_right_sidebar' => esc_attr__('Right', 'photty'),
                    'photty_no_sidebar' => esc_attr__('None', 'photty'),
                ),
            ),
        ),
    );

    # Fullscreen Templates
    $meta_boxes[] = array(
        'title' => esc_attr__('Gallery Template Settings', 'photty'),
        'post_types' => 'page',
        'fields' => array(
            array(
                'id' => 'photty_template_images',
                'name' => esc_attr__('Select Images', 'photty'),
                'type' => 'image_advanced',
            ),
            array(
                'id' => 'photty_slider_fit_style',
                'name' => esc_attr__('Fit Style', 'photty'),
                'type' => 'select',
                'options' => array(
					'no_fit' => esc_attr__('Cover Slide', 'photty'), 
					"fit_always" => esc_attr__('Fit Always', 'photty'), 
					"fit_width" => esc_attr__('Fit Horizontal', 'photty'), 
					"fit_height" => esc_attr__('Fit Vertical', 'photty')
                ),
                'attributes' => array(
                    'data-template-file' => 'page-fullscreen-slider.php',
                ),
            ),
            array(
                'id' => 'photty_slider_nav_style',
                'name' => esc_attr__('Navigation Style', 'photty'),
                'type' => 'select',
                'options' => array(
					'arrows' => esc_attr__('Arrows Navigation', 'photty'),
					'thumbs' => esc_attr__('Thumbs Navigation', 'photty')					
                ),
				'attributes' => array(
                    'data-template-file' => 'page-fullscreen-slider.php',
                ),
            ),
            array(
                'id' => 'photty_slider_autoplay',
                'name' => esc_attr__('Autoplay', 'photty'),
                'type' => 'select',
                'options' => array(
                    'no' => esc_attr__('No', 'photty'),
					'yes' => esc_attr__('Yes', 'photty'),
                ),
                'attributes' => array(
                    'data-template-file' => 'page-ribbon-slider.php, page-fullscreen-slider.php',
                ),
            ),
            array(
                'id' => 'photty_slider_interval',
                'name' => esc_attr__('Autoplay Interval', 'photty'),
                'type' => 'text',
                'std' => '4000',
                'attributes' => array(
                    'data-template-file' => 'page-ribbon-slider.php, page-fullscreen-slider.php',
                    'data-dependency-id' => 'photty_slider_autoplay',
                    'data-dependency-val' => 'yes'
                ),
            ),
        )
    );

    # Select Albums Category
    $meta_boxes[] = array(
        'title' => esc_attr__('Albums Category Settings', 'photty'),
        'post_types' => 'page',
        'fields' => array(
            array(
                'id' => 'photty_albums_taxonomy',
                'name' => esc_attr__('Select Categories', 'photty'),
                'type' => 'taxonomy',
				'taxonomy' => 'albumscat',
				'field_type' => 'checkbox_list',
            ),
        )
    );

    # Albums Listing
    $meta_boxes[] = array(
        'title' => esc_attr__('Albums Listing Settings', 'photty'),
        'post_types' => 'page',
        'fields' => array(

            array(
                'id' => 'photty_albums_on_start',
                'name' => esc_attr__('Album Items on Start', 'photty'),
                'type' => 'select',
                'options' => array(
                    '5' => esc_attr__('5 Items', 'photty'),
                    '10' => esc_attr__('10 Items', 'photty'),
                    '15' => esc_attr__('15 Items', 'photty'),
                    '20' => esc_attr__('20 Items', 'photty')
                ),
            ),
            array(
                'id' => 'photty_albums_per_load',
                'name' => esc_attr__('Album Items per Load', 'photty'),
                'type' => 'select',
                'options' => array(
                    '5' => esc_attr__('5 Items', 'photty'),
                    '10' => esc_attr__('10 Items', 'photty'),
                    '15' => esc_attr__('15 Items', 'photty'),
                    '20' => esc_attr__('20 Items', 'photty')
                ),
            ),
		
            array(
                'id' => 'photty_load_more_text',
                'name' => esc_attr__('Load More Button Text', 'photty'),
                'type' => 'text',
                'std' => esc_attr__('Load More', 'photty'),
                'attributes' => array(
                    'data-template-file' => 'page-albums.php'
                ),
            ),
        )
    );

    return $meta_boxes;
}