<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

add_action('customize_register', 'photty_customizer_register');
function photty_customizer_register($wp_customize)
{
    ###################################################
    ############# Header Settings Section #############
    ###################################################
    $wp_customize->add_section('photty_header_settings',
        array(
            'title' => esc_attr__('Header Settings', 'photty')
        )
    );

    # Logo Position
    $wp_setting_name = 'logo_position';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'logo_left', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Logo Position', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('logo_left' => 'Left', 'logo_center' => 'Center', 'logo_right' => 'Right'),
        )
    ));

    # Transparent Header
    $wp_setting_name = 'header_transparent';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'disabled', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Transparent Header', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('disabled' => 'Disabled', 'enabled' => 'Enabled'),
        )
    ));

    # Fullwidth Header
    $wp_setting_name = 'header_fw';
    $wp_customize->add_setting($wp_setting_name, array('default' => true, 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Fullwidth Header', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
            'type' => 'checkbox',
        )
    ));

    # Sticky Header
//    $wp_setting_name = 'sticky_header';
//    $wp_customize->add_setting($wp_setting_name, array('default' => true, 'sanitize_callback'	=> 'esc_attr'));
//    $wp_customize->add_control(new WP_Customize_Control(
//        $wp_customize,
//        $wp_setting_name,
//        array(
//            'label' => esc_attr__('Sticky Header', 'photty'),
//            'section' => 'photty_header_settings',
//            'settings' => $wp_setting_name,
//            'type' => 'checkbox',
//        )
//    ));

    # Sticky Header Opacity
//    $wp_setting_name = 'sticky_header_opacity';
//    $wp_customize->add_setting($wp_setting_name, array('default' => '100', 'sanitize_callback'	=> 'esc_attr'));
//    $wp_customize->add_control(new WP_Customize_Control(
//        $wp_customize,
//        $wp_setting_name,
//        array(
//            'label' => esc_attr__('Sticky Header Opacity (0 - 100)', 'photty'),
//            'section' => 'photty_header_settings',
//            'settings' => $wp_setting_name,
//        )
//    ));

    # Logo Type (Text or Image)
    $wp_setting_name = 'logo_type';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'image_logo', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Logo Type', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('image_logo' => 'Image', 'text_logo' => 'Text'),
        )
    ));

    # Logo (Selected Image)
    $wp_setting_name = 'logo_image';
    $wp_customize->add_setting($wp_setting_name, array('default' => get_template_directory_uri() . '/img/logo.png', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Image_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Logo Image', 'photty'),
            'section' => 'photty_header_settings',
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="logo_type" data-dependency-val="image_logo"></i>',
            'settings' => $wp_setting_name,
        )
    ));

    # Logo Retina
    $wp_setting_name = 'logo_retina';
    $wp_customize->add_setting($wp_setting_name, array('default' => true, 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Logo Retina', 'photty'),
            'section' => 'photty_header_settings',
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="logo_type" data-dependency-val="image_logo"></i>By activating this option you must use an image with 2х size more than you wish to show.',
            'settings' => $wp_setting_name,
            'type' => 'checkbox',
        )
    ));

    # Logo Text Caption
    $wp_setting_name = 'logo_text_caption';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'Text Logo', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Logo Text', 'photty'),
            'section' => 'photty_header_settings',
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="logo_type" data-dependency-val="text_logo"></i>',
            'settings' => $wp_setting_name,
        )
    ));

    # Logo Text Font
    $wp_setting_name = 'logo_text_font';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'Roboto', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Logo Font', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="logo_type" data-dependency-val="text_logo"></i>',
            'choices' => photty_get_all_fonts_name(),
        )
    ));

    # Logo Text Size
    $wp_setting_name = 'logo_text_size';
    $wp_customize->add_setting($wp_setting_name, array('default' => '24', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Logo Size, px', 'photty'),
            'section' => 'photty_header_settings',
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="logo_type" data-dependency-val="text_logo"></i>',
            'settings' => $wp_setting_name,
        )
    ));

    # Logo Text Weight
    $wp_setting_name = 'logo_text_weight';
    $wp_customize->add_setting($wp_setting_name, array('default' => '700', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Logo Font Weight', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="logo_type" data-dependency-val="text_logo"></i>Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.',
            'type' => 'select',
            'choices' => array('100' => '100', '200' => '200', '300' => '300', '400' => '400', '500' => '500', '600' => '600', '700' => '700', '800' => '800', '900' => '900'),
        )
    ));

    # Logo Text Style Uppercase
    $wp_setting_name = 'logo_text_style_uppercase';
    $wp_customize->add_setting($wp_setting_name, array('default' => true, 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Logo Uppercase', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
            'type' => 'checkbox',
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="logo_type" data-dependency-val="text_logo"></i>',
        )
    ));

    # Logo Text Style Italic
    $wp_setting_name = 'logo_text_style_italic';
    $wp_customize->add_setting($wp_setting_name, array('default' => false, 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Logo Italic', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="logo_type" data-dependency-val="text_logo"></i>',
            'type' => 'checkbox',
        )
    ));

    # Header Padding Top
    $wp_setting_name = 'logo_padding_top';
    $wp_customize->add_setting($wp_setting_name, array('default' => '22', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Logo Padding Top, px', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Header Padding Bottom
    $wp_setting_name = 'logo_padding_bottom';
    $wp_customize->add_setting($wp_setting_name, array('default' => '22', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Logo Padding Bottom, px', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Header Menu Font Family
    $wp_setting_name = 'header_menu_font_family';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'Roboto', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Header Menu Font Family', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => photty_get_all_fonts_name(),
        )
    ));

    # Header Menu Font-Size
    $wp_setting_name = 'header_menu_font_size';
    $wp_customize->add_setting($wp_setting_name, array('default' => '14', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Header Menu Font-Size, px', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Header Menu Weight
    $wp_setting_name = 'header_menu_font_weight';
    $wp_customize->add_setting($wp_setting_name, array('default' => '400', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Header Menu Font Weight', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
            'description' => 'Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.',
            'type' => 'select',
            'choices' => array('100' => '100', '200' => '200', '300' => '300', '400' => '400', '500' => '500', '600' => '600', '700' => '700', '800' => '800', '900' => '900'),
        )
    ));

    # Header Menu Uppercase
    $wp_setting_name = 'header_menu_uppercase';
    $wp_customize->add_setting($wp_setting_name, array('default' => true, 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Header Menu Uppercase', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
            'type' => 'checkbox',
        )
    ));

    # Header Menu Italic
    $wp_setting_name = 'header_menu_italic';
    $wp_customize->add_setting($wp_setting_name, array('default' => false, 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Header Menu Italic', 'photty'),
            'section' => 'photty_header_settings',
            'settings' => $wp_setting_name,
            'type' => 'checkbox',
        )
    ));

    ###################################################
    ############ Content Settings Section #############
    ###################################################
    $wp_customize->add_section('photty_content_settings',
        array(
            'title' => esc_attr__('Content Settings', 'photty')
        )
    );
	
    # Content Layout
    $wp_setting_name = 'content_layout';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'clean', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Content Layout', 'photty'),
            'section' => 'photty_content_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('clean' => 'Clean', 'boxed' => 'Boxed'),
        )
    ));
    $wp_setting_name = 'photty_pingbacks';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'on', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Pingbacks and Trackbacks', 'photty'),
            'section' => 'photty_content_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('on' => 'On', 'off' => 'Off'),
        )
    ));
    $wp_setting_name = 'default_overlay_state';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'show', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Galleries Overlay State', 'photty'),
            'section' => 'photty_content_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('show' => 'Show', 'hide' => 'Hide'),
        )
    ));
	

    ###################################################
    ########### Preloader Settings Section ############
    ###################################################
    $wp_customize->add_section('photty_preloader_settings',
        array(
            'title' => esc_attr__('Preloader Settings', 'photty')
        )
    );
	
    # Preloader On Off
    $wp_setting_name = 'preloader_state';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'on', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Content Layout', 'photty'),
            'section' => 'photty_preloader_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('on' => 'On', 'off' => 'Off'),
        )
    ));



    ###################################################
    ############## Footer Settings Section ############
    ###################################################
    $wp_customize->add_section('photty_footer_settings',
        array(
            'title' => esc_attr__('Footer Settings', 'photty')
        )
    );

    # Footer Logo Position
    $wp_setting_name = 'footer_logo_position';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'logo_left', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Logo Position', 'photty'),
            'section' => 'photty_footer_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('logo_left' => 'Left', 'logo_center' => 'Center', 'logo_right' => 'Right'),
        )
    ));

    # Footer Logo Type (Text or Image)
    $wp_setting_name = 'footer_logo_type';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'image_logo', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Logo Type', 'photty'),
            'section' => 'photty_footer_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('image_logo' => 'Image', 'text_logo' => 'Text'),
        )
    ));

    # Footer Logo (Selected Image)
    $wp_setting_name = 'footer_logo_image';
    $wp_customize->add_setting($wp_setting_name, array('default' => get_template_directory_uri() . '/img/logo.png', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Image_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Logo Image', 'photty'),
            'section' => 'photty_footer_settings',
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="footer_logo_type" data-dependency-val="image_logo"></i>',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Logo Retina
    $wp_setting_name = 'footer_logo_retina';
    $wp_customize->add_setting($wp_setting_name, array('default' => true, 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Logo Retina', 'photty'),
            'section' => 'photty_footer_settings',
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="footer_logo_type" data-dependency-val="image_logo"></i>By activating this option you must use an image with 2х size more than you wish to show.',
            'settings' => $wp_setting_name,
            'type' => 'checkbox',
        )
    ));

    # Footer Logo Text Caption
    $wp_setting_name = 'footer_logo_text_caption';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'Text Logo', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Logo Text', 'photty'),
            'section' => 'photty_footer_settings',
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="footer_logo_type" data-dependency-val="text_logo"></i>',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Logo Text Font
    $wp_setting_name = 'footer_logo_text_font';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'Roboto', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Logo Font', 'photty'),
            'section' => 'photty_footer_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="footer_logo_type" data-dependency-val="text_logo"></i>',
            'choices' => photty_get_all_fonts_name(),
        )
    ));

    # Footer Logo Text Size
    $wp_setting_name = 'footer_logo_text_size';
    $wp_customize->add_setting($wp_setting_name, array('default' => '24', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Logo Size, px', 'photty'),
            'section' => 'photty_footer_settings',
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="footer_logo_type" data-dependency-val="text_logo"></i>',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Logo Text Weight
    $wp_setting_name = 'footer_logo_text_weight';
    $wp_customize->add_setting($wp_setting_name, array('default' => '700', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Logo Font Weight', 'photty'),
            'section' => 'photty_footer_settings',
            'settings' => $wp_setting_name,
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="footer_logo_type" data-dependency-val="text_logo"></i>Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.',
            'type' => 'select',
            'choices' => array('100' => '100', '200' => '200', '300' => '300', '400' => '400', '500' => '500', '600' => '600', '700' => '700', '800' => '800', '900' => '900'),
        )
    ));

    # Footer Logo Text Style Uppercase
    $wp_setting_name = 'footer_logo_text_style_uppercase';
    $wp_customize->add_setting($wp_setting_name, array('default' => true, 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Logo Uppercase', 'photty'),
            'section' => 'photty_footer_settings',
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="footer_logo_type" data-dependency-val="text_logo"></i>',
            'settings' => $wp_setting_name,
            'type' => 'checkbox',
        )
    ));

    # Footer Logo Text Style Italic
    $wp_setting_name = 'footer_logo_text_style_italic';
    $wp_customize->add_setting($wp_setting_name, array('default' => false, 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Logo Italic', 'photty'),
            'section' => 'photty_footer_settings',
            'settings' => $wp_setting_name,
            'description' => '<i class="photty_dependency_customizer" data-dependency-id="footer_logo_type" data-dependency-val="text_logo"></i>',
            'type' => 'checkbox',
        )
    ));

    # Footer Logo Padding Top
    $wp_setting_name = 'footer_logo_padding_top';
    $wp_customize->add_setting($wp_setting_name, array('default' => '22', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Logo Padding Top, px', 'photty'),
            'section' => 'photty_footer_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Logo Padding Bottom
    $wp_setting_name = 'footer_logo_padding_bottom';
    $wp_customize->add_setting($wp_setting_name, array('default' => '22', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Logo Padding Bottom, px', 'photty'),
            'section' => 'photty_footer_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Copyright Text
    $wp_setting_name = 'footer_copyright_text';
    $footer_copyright_text_temp = esc_attr__('Copyright &copy; 2017 Photty. All Rights Reserved.', 'photty');
    $wp_customize->add_setting($wp_setting_name, array('default' => $footer_copyright_text_temp, 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Copyright Text', 'photty'),
            'section' => 'photty_footer_settings',
            'settings' => $wp_setting_name,
        )
    ));

    ###################################################
    ################# Sidebars Section ################
    ###################################################
    $wp_customize->add_section('photty_sidebars_settings',
        array(
            'title' => esc_attr__('Sidebars', 'photty')
        )
    );

    # Sidebar Position
    $wp_setting_name = 'sidebar_position';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'photty_right_sidebar', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Sidebar Position', 'photty'),
            'section' => 'photty_sidebars_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('photty_left_sidebar' => 'Left', 'photty_right_sidebar' => 'Right', 'photty_no_sidebar' => 'None'),
        )
    ));

    # Footer Widgets
    $wp_setting_name = 'footer_widgets_status';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'footer_widgets_on', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Widgets', 'photty'),
            'section' => 'photty_sidebars_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('footer_widgets_on' => 'Enabled', 'footer_widgets_off' => 'Disabled'),
        )
    ));

    # Footer Widgets in Row
    $wp_setting_name = 'footer_widgets_in_row';
    $wp_customize->add_setting($wp_setting_name, array('default' => '4', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Widgets in Row', 'photty'),
            'section' => 'photty_sidebars_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('3' => '3', '4' => '4'),
        )
    ));

    # Footer Widgets Padding Top
    $wp_setting_name = 'footer_widgets_padding_top';
    $wp_customize->add_setting($wp_setting_name, array('default' => '60', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Widgets Padding Top, px', 'photty'),
            'section' => 'photty_footer_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Widgets Padding Bottom
    $wp_setting_name = 'footer_widgets_padding_bottom';
    $wp_customize->add_setting($wp_setting_name, array('default' => '0', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Widgets Padding Bottom, px', 'photty'),
            'section' => 'photty_footer_settings',
            'settings' => $wp_setting_name,
        )
    ));

    ###################################################
    ############### Typography Section ################
    ###################################################
    $wp_customize->add_section('photty_typography_settings',
        array(
            'title' => esc_attr__('Typography', 'photty')
        )
    );

    # Main Font Family
    $wp_setting_name = 'main_font_family';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'Roboto', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Main Font Family', 'photty'),
            'section' => 'photty_typography_settings',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => photty_get_all_fonts_name(),
        )
    ));

    # Main Font-Size
    $wp_setting_name = 'main_font_size';
    $wp_customize->add_setting($wp_setting_name, array('default' => '14', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Main Font-Size, px', 'photty'),
            'section' => 'photty_typography_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Main Line-Height
    $wp_setting_name = 'main_line_height';
    $wp_customize->add_setting($wp_setting_name, array('default' => '22', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Main Line-Height, px', 'photty'),
            'section' => 'photty_typography_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Main Font Weight
    $wp_setting_name = 'main_font_weight';
    $wp_customize->add_setting($wp_setting_name, array('default' => '300', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Main Font Weight', 'photty'),
            'section' => 'photty_typography_settings',
            'settings' => $wp_setting_name,
            'description' => 'Please keep in mind that most fonts do not support such exotic thicknesses as the 100. The most common values: 300, 400, 600, 700.',
            'type' => 'select',
            'choices' => array('100' => '100', '200' => '200', '300' => '300', '400' => '400', '500' => '500', '600' => '600', '700' => '700', '800' => '800', '900' => '900'),
        )
    ));

    ###################################################
    ############## Color Settings Section #############
    ###################################################
    $wp_customize->add_section('photty_color_settings',
        array(
            'title' => esc_attr__('Color Settings', 'photty')
        )
    );

    # Content Background Color
    $wp_setting_name = 'body_bg_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#ffffff', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Content Background', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Boxed Background Color
    $wp_setting_name = 'boxed_bg_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#edeef0', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Boxed Background', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Main Theme Color
    $wp_setting_name = 'color_main';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#e44b3c', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Theme Color', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Content Color
    $wp_setting_name = 'color_content';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#737479', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Content Color', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Headings Color
    $wp_setting_name = 'color_headings';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#2b2d38', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Headings Color', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Header Background Color
    $wp_setting_name = 'header_bg_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#1f232f', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Header Background', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Logo Text Color
    $wp_setting_name = 'logo_text_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#ffffff', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Text Logo', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Logo Text Hover Color
    $wp_setting_name = 'logo_text_hover';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#e44b3c', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Text Logo Hover', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Logo Text Color (Transparent Header)
    $wp_setting_name = 'logo_text_color_transparent_header';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#ffffff', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Text Logo (Transparent Header)', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Logo Text Hover Color (Transparent Header)
    $wp_setting_name = 'logo_text_hover_transparent_header';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#e44b3c', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Text Logo Hover (Transparent Header)', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Header Links Color
    $wp_setting_name = 'header_links_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#ffffff', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Header Menu', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Header Links Hover Color
    $wp_setting_name = 'header_links_hover_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#e44b3c', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Header Menu Hover', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Header Links Color (Transparent Header)
    $wp_setting_name = 'header_links_color_transparent_header';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#ffffff', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Header Menu (Transparent Header)', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Header Sub-Menu Spacer Color
    $wp_setting_name = 'header_sub_menu_spacer_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#363944', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Header Sub-Menu Spacer', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Background Color
    $wp_setting_name = 'footer_bg_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#1f232f', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Background', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Border Color
    $wp_setting_name = 'footer_border_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#363944', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Border', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Logo Text Color
    $wp_setting_name = 'footer_logo_text_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#ffffff', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Text Logo', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Logo Text Hover Color
    $wp_setting_name = 'footer_logo_text_hover';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#e44b3c', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Text Logo Hover', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Copyright
    $wp_setting_name = 'footer_copyright_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#ffffff', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Copyright Text', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Headings
    $wp_setting_name = 'footer_headings_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#ffffff', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Headings', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Text Color
    $wp_setting_name = 'footer_text_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#737479', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Text Color', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Links Color
    $wp_setting_name = 'footer_links_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#ffffff', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Links Color', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # Footer Links Hover Color
    $wp_setting_name = 'footer_links_hover_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#e44b3c', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Footer Links Hover Color', 'photty'),
            'section' => 'photty_color_settings',
            'settings' => $wp_setting_name,
        )
    ));

    ###################################################
    ########### Blog Featured Posts Section ###########
    ###################################################
    $wp_customize->add_section('photty_featured_posts',
        array(
            'title' => esc_attr__('Blog Featured Posts', 'photty')
        )
    );

    # Featured Posts Status
    $wp_setting_name = 'featured_posts_status';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'enabled', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Featured Posts Status', 'photty'),
            'section' => 'photty_featured_posts',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('enabled' => 'Enabled', 'disabled' => 'Disabled'),
        )
    ));

    # Featured Posts Order By
    $wp_setting_name = 'featured_posts_orderby';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'rand', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Featured Posts Order By', 'photty'),
            'section' => 'photty_featured_posts',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('rand' => 'Random', 'date' => 'Date'),
        )
    ));

    # Featured Posts Number
    $wp_setting_name = 'featured_posts_numberposts';
    $wp_customize->add_setting($wp_setting_name, array('default' => '2', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Number of Posts', 'photty'),
            'section' => 'photty_featured_posts',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('2' => '2', '3' => '3', '4' => '4'),
        )
    ));

    # Featured Posts Feature Image
    $wp_setting_name = 'featured_posts_fimage_status';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'show', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Feature Image', 'photty'),
            'section' => 'photty_featured_posts',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('show' => 'Show', 'hide' => 'Hide'),
        )
    ));

    # Featured Posts Meta
    $wp_setting_name = 'featured_posts_meta_status';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'show', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Post Meta', 'photty'),
            'section' => 'photty_featured_posts',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('show' => 'Show', 'hide' => 'Hide'),
        )
    ));

    # Featured Posts Excerpt
    $wp_setting_name = 'featured_posts_excerpt_status';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'show', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Excerpt', 'photty'),
            'section' => 'photty_featured_posts',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('show' => 'Show', 'hide' => 'Hide'),
        )
    ));
    
    ###################################################
    ########### Album Featured Posts Section ##########
    ###################################################
    $wp_customize->add_section('photty_featured_albums',
        array(
            'title' => esc_attr__('Featured Albums', 'photty')
        )
    );

    # Featured Posts Status
    $wp_setting_name = 'featured_albums_status';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'enabled', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Featured Albums Status', 'photty'),
            'section' => 'photty_featured_albums',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('enabled' => 'Enabled', 'disabled' => 'Disabled'),
        )
    ));

    # Featured Posts Order By
    $wp_setting_name = 'featured_albums_orderby';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'rand', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Featured Albums Order By', 'photty'),
            'section' => 'photty_featured_albums',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('rand' => 'Random', 'date' => 'Date'),
        )
    ));

    # Featured Posts Number
    $wp_setting_name = 'featured_albums_numberposts';
    $wp_customize->add_setting($wp_setting_name, array('default' => '3', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Number of Albums', 'photty'),
            'section' => 'photty_featured_albums',
            'settings' => $wp_setting_name,
            'type' => 'select',
            'choices' => array('2' => '2', '3' => '3', '4' => '4'),
        )
    ));

    ###################################################
    ################ Error 404 Section ################
    ###################################################
    $wp_customize->add_section('photty_error404_page_settings',
        array(
            'title' => esc_attr__('Error 404 Page', 'photty')
        )
    );

    # 404 Page Backgroung Image
    $wp_setting_name = '404_bg_image';
    $wp_customize->add_setting($wp_setting_name, array('default' => get_template_directory_uri() . '/img/null.png', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Image_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Background Image', 'photty'),
            'section' => 'photty_error404_page_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # 404 Page Text Color
    $wp_setting_name = '404_text_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#ffffff', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Text Color', 'photty'),
            'section' => 'photty_error404_page_settings',
            'settings' => $wp_setting_name,
        )
    ));

    ###################################################
    ############ Password Protected Section ###########
    ###################################################
    $wp_customize->add_section('photty_protected_page_settings',
        array(
            'title' => esc_attr__('Password Protected Page', 'photty')
        )
    );

    # 404 Page Backgroung Image
    $wp_setting_name = 'protected_bg_image';
    $wp_customize->add_setting($wp_setting_name, array('default' => get_template_directory_uri() . '/img/null.png', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Image_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Background Image', 'photty'),
            'section' => 'photty_protected_page_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # 404 Page Text Color
    $wp_setting_name = 'protected_text_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#ffffff', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Text Color', 'photty'),
            'section' => 'photty_protected_page_settings',
            'settings' => $wp_setting_name,
        )
    ));

    ###################################################
    #################### CS Section ###################
    ###################################################
    $wp_customize->add_section('photty_cs_page_settings',
        array(
            'title' => esc_attr__('Coming Soon Page', 'photty')
        )
    );

    # 404 Page Backgroung Image
    $wp_setting_name = 'cs_bg_image';
    $wp_customize->add_setting($wp_setting_name, array('default' => get_template_directory_uri() . '/img/null.png', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Image_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Background Image', 'photty'),
            'section' => 'photty_cs_page_settings',
            'settings' => $wp_setting_name,
        )
    ));

    # 404 Page Text Color
    $wp_setting_name = 'cs_text_color';
    $wp_customize->add_setting($wp_setting_name, array('default' => '#ffffff', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Color_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Text Color', 'photty'),
            'section' => 'photty_cs_page_settings',
            'settings' => $wp_setting_name,
        )
    ));

    ###################################################
    ################# Code Before Head ################
    ###################################################
    $wp_customize->add_section('photty_code_before_head',
        array(
            'title' => esc_attr__('Code Before &lt;/head&gt;', 'photty')
        )
    );

    # Code Before Head
    $wp_setting_name = 'photty_code_before_head_val';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'wp_specialchars_decode'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Code Before &lt;/head&gt;', 'photty'),
            'section' => 'photty_code_before_head',
            'type' => 'textarea',
            'settings' => $wp_setting_name,
        )
    ));

    ###################################################
    ############## Social Icons Section ###############
    ###################################################
    $wp_customize->add_section('photty_social_icons',
        array(
            'title' => esc_attr__('Social Icons', 'photty')
        )
    );
	
    $wp_setting_name = 'photty_soc_facebook';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'esc_url'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Facebook', 'photty'),
            'section' => 'photty_social_icons',
            'settings' => $wp_setting_name,
        )
    ));
    $wp_setting_name = 'photty_soc_twitter';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'esc_url'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Twitter', 'photty'),
            'section' => 'photty_social_icons',
            'settings' => $wp_setting_name,
        )
    ));
    $wp_setting_name = 'photty_soc_linkedin';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'esc_url'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('LinkedIn', 'photty'),
            'section' => 'photty_social_icons',
            'settings' => $wp_setting_name,
        )
    ));
    $wp_setting_name = 'photty_soc_youtube';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'esc_url'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('YouTube', 'photty'),
            'section' => 'photty_social_icons',
            'settings' => $wp_setting_name,
        )
    ));
    $wp_setting_name = 'photty_soc_instagram';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'esc_url'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Instagram', 'photty'),
            'section' => 'photty_social_icons',
            'settings' => $wp_setting_name,
        )
    ));
    $wp_setting_name = 'photty_soc_pinterest';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'esc_url'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Pinterest', 'photty'),
            'section' => 'photty_social_icons',
            'settings' => $wp_setting_name,
        )
    ));
    $wp_setting_name = 'photty_soc_tumblr';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'esc_url'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Tumblr', 'photty'),
            'section' => 'photty_social_icons',
            'settings' => $wp_setting_name,
        )
    ));
    $wp_setting_name = 'photty_soc_flickr';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'esc_url'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Flickr', 'photty'),
            'section' => 'photty_social_icons',
            'settings' => $wp_setting_name,
        )
    ));
    $wp_setting_name = 'photty_soc_vk';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'esc_url'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('VK', 'photty'),
            'section' => 'photty_social_icons',
            'settings' => $wp_setting_name,
        )
    ));
    $wp_setting_name = 'photty_soc_dribbble';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'esc_url'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Dribbble', 'photty'),
            'section' => 'photty_social_icons',
            'settings' => $wp_setting_name,
        )
    ));
    $wp_setting_name = 'photty_soc_vimeo';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'esc_url'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Vimeo', 'photty'),
            'section' => 'photty_social_icons',
            'settings' => $wp_setting_name,
        )
    ));
    $wp_setting_name = 'photty_soc_500px';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'esc_url'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('500px', 'photty'),
            'section' => 'photty_social_icons',
            'settings' => $wp_setting_name,
        )
    ));
    $wp_setting_name = 'photty_soc_snapchat';
    $wp_customize->add_setting($wp_setting_name, array('default' => '', 'sanitize_callback'	=> 'esc_url'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Snapchat', 'photty'),
            'section' => 'photty_social_icons',
            'settings' => $wp_setting_name,
        )
    ));
	
    #######################################################
    ############## Custom Post Types Section ##############
    #######################################################
    $wp_customize->add_section('photty_custom_post_types',
        array(
            'title' => esc_attr('Advanced', 'photty')
        )
    );

    # Albums Name
    $wp_setting_name = 'albums_pt_name';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'Albums', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Albums Post Type Name' , 'photty'),
            'section' => 'photty_custom_post_types',
            'settings' => $wp_setting_name,
        )
    ));
	
    # Albums Slug
    $wp_setting_name = 'albums_pt_slug';
    $wp_customize->add_setting($wp_setting_name, array('default' => 'albums', 'sanitize_callback'	=> 'esc_attr'));
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        $wp_setting_name,
        array(
            'label' => esc_attr__('Albums Post Type Slug' , 'photty'),
            'section' => 'photty_custom_post_types',
            'settings' => $wp_setting_name,
        )
    ));	
}