<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

add_action('wp_ajax_photty_ajax_query_posts', 'photty_ajax_query_posts');
add_action('wp_ajax_nopriv_photty_ajax_query_posts', 'photty_ajax_query_posts');
function photty_ajax_query_posts()
{
    $args = json_decode(stripslashes(sanitize_text_field($_POST['photty_ajax_query_posts'])));
	
	if ($args->output_template == 'albums_listing_template' && $args->terms !== '') {
		$selected_categories = $args->terms;
		$post_type_terms = array();
		if (isset($selected_categories) && strlen($selected_categories) > 0) {
			$post_type_terms = explode(",", $selected_categories);
		}

		$args->tax_query = array(
			array(
				'taxonomy' => 'albumscat',
				'field' => 'id',
				'terms' => $post_type_terms
			)
		);
	}
	query_posts($args);
	$albums_count = 0;

    if (have_posts()) {
        while (have_posts()) {
            the_post();
			# Albums Lising
			if ($args->output_template == 'albums_listing_template') {
				$albums_count++;
				if ($albums_count > 5) {
					$albums_count = 1;
				}
				$img_width = 915;
				$img_height = 600;
				$galCateg = '';
				$new_term_list = get_the_terms(get_the_id(), "albumscat");
                if (is_array($new_term_list)) {
                    foreach ($new_term_list as $term) {
						$galCateg .= '<a href="'.get_term_link($term->slug, "albumscat").'">' . $term->name . '</a> / ';
                    }
                } else {
                    $galCateg = 'Uncategorized  ';
                }
				$galCateg = substr($galCateg, 0, -2);
				
				$html = '
				<div class="photty_album_post_wrapper photty_album_post_loading album_item_'. $albums_count .'" id="post-' . get_the_ID() . '">
					<div class="photty_album_post_inner">
						<div class="photty_album_image">
							<a href="' . get_permalink() . '" class="photty_image_fader">
								<img class="photty_stand_fi" src="' . aq_resize(photty_get_featured_image_url(), $img_width, $img_height, true, true, true) . '" alt="'. get_the_title() .'" />
							</a>
						</div>
						<div class="photty_album_content">
							<a class="notextdecor" href="' . get_permalink() . '"><h5 class="innertitle entry-title">' . get_the_title() . '</h5></a>
							<div class="photty_albums_categories">
								'. $galCateg .'
							</div>
						</div>
					</div>
				</div>
				';
				echo photty_output($html);
			}
			
            # Grid Blog Module
            if ($args->output_template == 'blog_grid_template') {
				$photty_pf_args = array(
					'output_template' => 'blog_grid',
					'grid_img_width' => $args->thmb_width,
					'grid_img_height' => $args->thmb_height
				);
				
				$html = '
				<div class="photty_grid_post_wrapper photty_grid_post_loading" id="post-' . get_the_ID() . '">
					<div class="photty_grid_post_inner">
						' . photty_get_post_formats($photty_pf_args) . '
						<div class="photty_grid_post_content">
							<div class="photty_grid_post_title">
								<a class="notextdecor" href="' . get_permalink() . '"><h5 class="innertitle entry-title">' . get_the_title() . '</h5></a>
							</div>
							<div class="photty_grid_post_meta photty_meta">
								<div>' . get_the_date() . '</div>
								<div>' . get_the_author_posts_link() . '</div>';
				
						$categories = get_the_category();
						$separator = ', ';
						if (!empty($categories)) {
							$html .= '
								<div>';
							foreach ($categories as $category) {
								$html .= '<a href="' . esc_url(get_category_link($category->term_id)) . '" alt="' . esc_attr(sprintf(__('View all posts in %s', 'photty'), $category->name)) . '">' . esc_html($category->name) . '</a>' . $separator;
							}
							$html = trim($html, $separator);
							$html .= '
								</div>';
						}
				
						$html .= '
							</div>
							<div class="photty_excerpt">
								' . get_the_excerpt() . '
							</div>
						</div>
					</div>
				</div>
				';
				echo photty_output($html);
            }

            # Template 1
            if ($args->output_template == 'template1') {
                the_title();
            }

        }
        wp_reset_query();
    }

    die();
}

# Reset All Settings
add_action('wp_ajax_photty_reset_all_settings', 'photty_reset_all_settings');
function photty_reset_all_settings()
{
	if (!current_user_can('manage_options')) {
        wp_die(esc_html__('You do not have permissions to access this page.', 'photty'));
    }
    
	remove_theme_mods();
	
	die(esc_html__('Done!', 'photty'));
}