<?php
/*
 * Created by Pixel-Mafia
 * www.pixel-mafia.com
*/

if (post_password_required()) {
    return;
}

# Enqueue Comment Reply JS
if (is_singular() && comments_open()) {
    wp_enqueue_script('comment-reply');
}

function photty_comment_html($comment, $args, $depth)
{
    $GLOBALS['comment'] = $comment;
    ?>

<div <?php comment_class(); ?> id="comment-<?php comment_ID() ?>">
    <div class="photty_comment_ava">
        <?php echo get_avatar($comment->comment_author_email, $args['avatar_size']); ?>
    </div>
    <div class="photty_comment_body">
        <?php
        if ($comment->comment_approved == '0') {
            echo '<p>' . esc_html__('Your comment is awaiting moderation.', 'photty') . '</p>';
        }
        echo '
        <h5 class="innertitle">' . get_comment_author() . '</h5>
        <div class="photty_comment_date">' . get_comment_date() . '</div>
        ';
        comment_text();
        edit_comment_link('Edit');
        comment_reply_link(
            array_merge(
                $args, array(
                    'before' => ' <div class="photty_comment_reply">',
                    'after' => '</div>',
                    'depth' => $depth,
                    'reply_text' => esc_html__('Reply', 'photty'),
                    'max_depth' => $args['max_depth']
                )
            )
        );
        ?>
    </div>
    <?php
}

if (comments_open() || have_comments()) {
    ?>

    <div class="photty_comments_cont">
        <h3 class="photty_tac photty_comments_title"><?php comments_number();
            echo ' ';
            echo esc_attr__('on This Post', 'photty'); ?></h3>
        <?php
        if (have_comments()) {
            the_comments_navigation();
            ?>

            <div class="photty_comment_list">
                <?php
				if (get_theme_mod('photty_pingbacks', 'on') == 'on') {
					wp_list_comments(array(
						'type' => 'all',
						'style' => 'div',
						'max_depth' => '5',
						'avatar_size' => 70,
						'callback' => 'photty_comment_html'
					));
				} else {
					wp_list_comments(array(
						'type' => 'comment',
						'style' => 'div',
						'max_depth' => '5',
						'avatar_size' => 70,
						'callback' => 'photty_comment_html'
					));					
				}
                ?>
            </div>

            <?php the_comments_navigation();
        }

        $photty_comments_field_req = get_option('require_name_email');

        comment_form(array(
            'title_reply_before' => '<h3 class="photty_reply_comment_title photty_tac">',
            'title_reply_after' => '</h3>',
            'fields' => array(
                'author' => '<div class="row"><div class="comment-form-author col-md-6"><input placeholder="'.esc_attr__('Your Name', 'photty') . ($photty_comments_field_req ? ' *' : '').'" name="author" type="text" value="' . esc_attr($commenter['comment_author']) . '" size="30" /></div>',
                'email' => '<div class="comment-form-email col-md-6"><input placeholder="'.esc_attr__('Your Email', 'photty') . ($photty_comments_field_req ? ' *' : '').'" name="email" type="text" value="' . esc_attr($commenter['comment_author_email']) . '" size="30" /></div></div>',
            ),
        ));
        ?>
    </div>

    <?php
}